/*
 * Decompiled with CFR 0.152.
 */
package org.xmlunit.assertj3;

import java.util.regex.Pattern;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.junit.internal.matchers.ThrowableMessageMatcher;
import org.junit.rules.TestRule;
import org.junit.runners.model.Statement;

public class ExpectedException
implements TestRule {
    private final org.junit.rules.ExpectedException delegate = org.junit.rules.ExpectedException.none();
    private boolean checkAssertionType = false;

    public static ExpectedException none() {
        return new ExpectedException();
    }

    private ExpectedException() {
    }

    public Statement apply(Statement base, org.junit.runner.Description description) {
        return this.delegate.apply(base, description);
    }

    public void expectAssertionError(String message) {
        this.expectAssertionError();
        this.delegate.expectMessage(String.format(message, new Object[0]));
    }

    public void expectAssertionErrorPattern(String messageRegex) {
        this.expectAssertionError();
        this.delegate.expect(ThrowableMessageMatcher.hasMessage((Matcher)new MatchesPattern(messageRegex)));
    }

    private void expectAssertionError() {
        if (!this.checkAssertionType) {
            this.delegate.expect(AssertionError.class);
            this.checkAssertionType = true;
        }
    }

    private class MatchesPattern
    extends TypeSafeMatcher<String> {
        private String regex;

        MatchesPattern(String regex) {
            this.regex = regex;
        }

        protected boolean matchesSafely(String item) {
            return Pattern.compile(this.regex, 32).matcher(item).matches();
        }

        public void describeTo(Description description) {
            description.appendText("a string matching the regex '" + this.regex + "'");
        }
    }
}

