/*
 * Decompiled with CFR 0.152.
 */
package org.xmlunit.assertj3;

import javax.xml.xpath.XPathFactory;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.xmlunit.assertj3.ExpectedException;
import org.xmlunit.assertj3.XmlAssert;

public class MultipleNodeAssertDoNotHaveAttributeTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testDoNotHaveAttribute_withAnyValue_shouldPass() {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><feed>   <title>title</title>   <entry attr1=\"value\">       <title>title1</title>   </entry>   <entry attr2=\"value2\">       <title>title1</title>   </entry></feed>";
        XmlAssert.assertThat((Object)xml).nodesByXPath("/feed/entry").doNotHaveAttribute("attr");
    }

    @Test
    public void testDoNotHaveAttribute_withValue_shouldPass() {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><feed>   <title>title</title>   <entry attr1=\"value\">       <title>title1</title>   </entry>   <entry attr=\"abc\">       <title>title1</title>   </entry></feed>";
        XmlAssert.assertThat((Object)xml).nodesByXPath("/feed/entry").doNotHaveAttribute("attr", "value");
    }

    @Test
    public void testDoNotHaveAttribute_withMultipleAttributes_shouldPass() {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><feed>   <title>title</title>   <entry abc=\"value1\" aaa=\"def\">       <title>title1</title>   </entry>   <title>title</title>   <entry xyz=\"value4\" bbb=\"aaa\">       <title>title1</title>   </entry></feed>";
        XmlAssert.assertThat((Object)xml).nodesByXPath("/feed/entry").doNotHaveAttribute("attr1").doNotHaveAttribute("attr2");
    }

    @Test
    public void testDoNotHaveAttribute_withMultipleAttributeWithValues_shouldPass() {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><feed>   <title>title</title>   <entry attr1=\"abc\" xyz=\"value2\">       <title>title1</title>   </entry>   <entry def=\"value2\" attr1=\"ghi\">       <title>title1</title>   </entry></feed>";
        XmlAssert.assertThat((Object)xml).nodesByXPath("/feed/entry").doNotHaveAttribute("attr1", "value1").doNotHaveAttribute("attr2", "value2");
    }

    @Test
    public void testDoNotHaveAttribute_withAnyValue_shouldFail() {
        this.thrown.expectAssertionError("check node at index 1");
        this.thrown.expectAssertionError(String.format("Expecting:%n <entry>%nnot to have attribute:%n <attr>", new Object[0]));
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><feed>   <title>title</title>   <entry abc=\"value\">       <title>title1</title>   </entry>   <entry attr=\"value2\">       <title>title1</title>   </entry></feed>";
        XmlAssert.assertThat((Object)xml).hasXPath("/feed/entry").doNotHaveAttribute("attr");
    }

    @Test
    public void testDoNotHaveAttribute_withAnyValue_shouldUseCustomFailMessage() {
        this.thrown.expectAssertionError("Alarm alarm!");
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><feed>   <title>title</title>   <entry abc=\"value\">       <title>title1</title>   </entry>   <entry attr=\"value2\">       <title>title1</title>   </entry></feed>";
        ((XmlAssert)XmlAssert.assertThat((Object)xml).withFailMessage("Alarm alarm!", new Object[0])).hasXPath("/feed/entry").doNotHaveAttribute("attr");
    }

    @Test
    public void testDoNotHaveAttribute_withValue_shouldFail() {
        this.thrown.expectAssertionError("check node at index 1");
        this.thrown.expectAssertionError(String.format("Expecting:%n <entry>%nnot to have attribute:%n <attr>%nwith value:%n <value>", new Object[0]));
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><feed>   <title>title</title>   <entry attr=\"value2\">       <title>title1</title>   </entry>   <entry attr=\"value\">       <title>title1</title>   </entry></feed>";
        XmlAssert.assertThat((Object)xml).hasXPath("/feed/entry").doNotHaveAttribute("attr", "value");
    }

    @Test
    public void testDoNotHaveAttribute_withValue_shouldUseCustomFailMessage() {
        this.thrown.expectAssertionError("Alarm alarm!");
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><feed>   <title>title</title>   <entry attr=\"value2\">       <title>title1</title>   </entry>   <entry attr=\"value\">       <title>title1</title>   </entry></feed>";
        ((XmlAssert)XmlAssert.assertThat((Object)xml).withFailMessage("Alarm alarm!", new Object[0])).hasXPath("/feed/entry").doNotHaveAttribute("attr", "value");
    }

    @Test
    public void testDoNotHaveAttribute_withMultipleAttributes_shouldFail() {
        this.thrown.expectAssertionError("check node at index 2");
        this.thrown.expectAssertionError(String.format("Expecting:%n <entry>%nnot to have attribute:%n <attr1>", new Object[0]));
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><feed>   <title>title</title>   <entry abc=\"value1\" def=\"value2\">       <title>title1</title>   </entry>   <title>title</title>   <entry>       <title>title1</title>   </entry>   <entry attr1=\"value5\">       <title>title1</title>   </entry></feed>";
        XmlAssert.assertThat((Object)xml).nodesByXPath("/feed/entry").doNotHaveAttribute("attr1").doNotHaveAttribute("attr2");
    }

    @Test
    public void testDoNotHaveAttribute_withMultipleAttributes_shouldUseCustomFailMessage() {
        this.thrown.expectAssertionError("Alarm alarm!");
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><feed>   <title>title</title>   <entry abc=\"value1\" def=\"value2\">       <title>title1</title>   </entry>   <title>title</title>   <entry>       <title>title1</title>   </entry>   <entry attr1=\"value5\">       <title>title1</title>   </entry></feed>";
        ((XmlAssert)XmlAssert.assertThat((Object)xml).withFailMessage("Alarm alarm!", new Object[0])).nodesByXPath("/feed/entry").doNotHaveAttribute("attr1").doNotHaveAttribute("attr2");
    }

    @Test
    public void testDoNotHaveAttribute_withMultipleAttributeWithValues_shouldFail() {
        this.thrown.expectAssertionError("check node at index 2");
        this.thrown.expectAssertionError(String.format("Expecting:%n <entry>%nnot to have attribute:%n <attr2>%nwith value:%n <value2>", new Object[0]));
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><feed>   <title>title</title>   <entry attr1=\"value2\" attr2=\"value1\">       <title>title1</title>   </entry>   <entry abc=\"value1\">       <title>title1</title>   </entry>   <entry attr1=\"VALUE1\" attr2=\"value2\">       <title>title1</title>   </entry>   <entry attr1=\"value2\" attr2=\"value1\">       <title>title1</title>   </entry></feed>";
        XmlAssert.assertThat((Object)xml).nodesByXPath("/feed/entry").doNotHaveAttribute("attr1", "value1").doNotHaveAttribute("attr2", "value2");
    }

    @Test
    public void testDoNotHaveAttribute_withMultipleAttributeWithValues_shouldUseCustomFailMessage() {
        this.thrown.expectAssertionError("Alarm alarm!");
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><feed>   <title>title</title>   <entry attr1=\"value2\" attr2=\"value1\">       <title>title1</title>   </entry>   <entry abc=\"value1\">       <title>title1</title>   </entry>   <entry attr1=\"VALUE1\" attr2=\"value2\">       <title>title1</title>   </entry>   <entry attr1=\"value2\" attr2=\"value1\">       <title>title1</title>   </entry></feed>";
        ((XmlAssert)XmlAssert.assertThat((Object)xml).withFailMessage("Alarm alarm!", new Object[0])).nodesByXPath("/feed/entry").doNotHaveAttribute("attr1", "value1").doNotHaveAttribute("attr2", "value2");
    }

    @Test
    public void testNotHaveAttribute_forEmptyNodeSet_shouldPass() {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><feed>   <title>title</title>   <entry attr1=\"value1\" attr2=\"value2\">       <title>title1</title>   </entry>   <entry attr1=\"value1\" attr2=\"value2\">       <title>title1</title>   </entry></feed>";
        XmlAssert.assertThat((Object)xml).nodesByXPath("/feed/abc").doNotHaveAttribute("attr1").doNotHaveAttribute("attr2", "value2");
    }

    @Test
    public void usesXPathEngine() {
        XPathFactory xFac = (XPathFactory)Mockito.mock(XPathFactory.class);
        Mockito.when((Object)xFac.newXPath()).thenReturn((Object)XPathFactory.newInstance().newXPath());
        XmlAssert.assertThat((Object)"<foo/>").withXPathFactory(xFac).nodesByXPath("//bar").doNotHaveAttribute("attr1");
        ((XPathFactory)Mockito.verify((Object)xFac)).newXPath();
    }
}

