/*
 * Decompiled with CFR 0.152.
 */
package org.xmlunit.assertj3;

import org.junit.Rule;
import org.junit.Test;
import org.xmlunit.assertj3.ExpectedException;
import org.xmlunit.assertj3.XmlAssert;

public class MultipleNodeAssertHaveAttributeTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testHaveAttribute_withAnyValue_shouldPass() {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><feed>   <title>title</title>   <entry attr=\"value\">       <title>title1</title>   </entry>   <entry attr=\"value2\">       <title>title1</title>   </entry></feed>";
        XmlAssert.assertThat((Object)xml).nodesByXPath("/feed/entry").haveAttribute("attr");
    }

    @Test
    public void testHaveAttribute_withValue_shouldPass() {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><feed>   <title>title</title>   <entry attr=\"value\">       <title>title1</title>   </entry>   <entry attr=\"value\">       <title>title1</title>   </entry></feed>";
        XmlAssert.assertThat((Object)xml).nodesByXPath("/feed/entry").haveAttribute("attr", "value");
    }

    @Test
    public void testHaveAttribute_withMultipleAttributes_shouldPass() {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><feed>   <title>title</title>   <entry attr1=\"value1\" attr2=\"value2\">       <title>title1</title>   </entry>   <title>title</title>   <entry attr2=\"value4\" attr1=\"value3\">       <title>title1</title>   </entry></feed>";
        XmlAssert.assertThat((Object)xml).nodesByXPath("/feed/entry").haveAttribute("attr1").haveAttribute("attr2");
    }

    @Test
    public void testHaveAttribute_withMultipleAttributeWithValues_shouldPass() {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><feed>   <title>title</title>   <entry attr1=\"value1\" attr2=\"value2\">       <title>title1</title>   </entry>   <entry attr2=\"value2\" attr1=\"value1\">       <title>title1</title>   </entry></feed>";
        XmlAssert.assertThat((Object)xml).nodesByXPath("/feed/entry").haveAttribute("attr1", "value1").haveAttribute("attr2", "value2");
    }

    @Test
    public void testHaveAttribute_withAnyValue_shouldFail() {
        this.thrown.expectAssertionError("check node at index 1");
        this.thrown.expectAssertionError(String.format("Expecting:%n <entry>%nto have attribute:%n <attr>", new Object[0]));
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><feed>   <title>title</title>   <entry attr=\"value\">       <title>title1</title>   </entry>   <entry attr2=\"value2\">       <title>title1</title>   </entry></feed>";
        XmlAssert.assertThat((Object)xml).hasXPath("/feed/entry").haveAttribute("attr");
    }

    @Test
    public void testHaveAttribute_withAnyValue_shouldUseCustomFailMessage() {
        this.thrown.expectAssertionError("Alarm alarm!");
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><feed>   <title>title</title>   <entry attr=\"value\">       <title>title1</title>   </entry>   <entry attr2=\"value2\">       <title>title1</title>   </entry></feed>";
        ((XmlAssert)XmlAssert.assertThat((Object)xml).withFailMessage("Alarm alarm!", new Object[0])).hasXPath("/feed/entry").haveAttribute("attr");
    }

    @Test
    public void testHaveAttribute_withValue_shouldFail() {
        this.thrown.expectAssertionError("check node at index 1");
        this.thrown.expectAssertionError(String.format("Expecting:%n <entry>%nto have attribute:%n <attr>%nwith value:%n <value>", new Object[0]));
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><feed>   <title>title</title>   <entry attr=\"value\">       <title>title1</title>   </entry>   <entry attr=\"value2\">       <title>title1</title>   </entry></feed>";
        XmlAssert.assertThat((Object)xml).hasXPath("/feed/entry").haveAttribute("attr", "value");
    }

    @Test
    public void testHaveAttribute_withValue_shouldUseCustomFailMessage() {
        this.thrown.expectAssertionError("Alarm alarm!");
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><feed>   <title>title</title>   <entry attr=\"value\">       <title>title1</title>   </entry>   <entry attr=\"value2\">       <title>title1</title>   </entry></feed>";
        ((XmlAssert)XmlAssert.assertThat((Object)xml).withFailMessage("Alarm alarm!", new Object[0])).hasXPath("/feed/entry").haveAttribute("attr", "value");
    }

    @Test
    public void testHaveAttribute_withMultipleAttributes_shouldFail() {
        this.thrown.expectAssertionError("check node at index 2");
        this.thrown.expectAssertionError(String.format("Expecting:%n <entry>%nto have attribute:%n <attr2>", new Object[0]));
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><feed>   <title>title</title>   <entry attr1=\"value1\" attr2=\"value2\">       <title>title1</title>   </entry>   <title>title</title>   <entry attr2=\"value4\" attr1=\"value3\">       <title>title1</title>   </entry>   <entry attr1=\"value5\">       <title>title1</title>   </entry></feed>";
        XmlAssert.assertThat((Object)xml).nodesByXPath("/feed/entry").haveAttribute("attr1").haveAttribute("attr2");
    }

    @Test
    public void testHaveAttribute_withMultipleAttributes_shouldUseCustomFailMessage() {
        this.thrown.expectAssertionError("Alarm alarm!");
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><feed>   <title>title</title>   <entry attr1=\"value1\" attr2=\"value2\">       <title>title1</title>   </entry>   <title>title</title>   <entry attr2=\"value4\" attr1=\"value3\">       <title>title1</title>   </entry>   <entry attr1=\"value5\">       <title>title1</title>   </entry></feed>";
        ((XmlAssert)XmlAssert.assertThat((Object)xml).withFailMessage("Alarm alarm!", new Object[0])).nodesByXPath("/feed/entry").haveAttribute("attr1").haveAttribute("attr2");
    }

    @Test
    public void testHaveAttribute_withMultipleAttributeWithValues_shouldFail() {
        this.thrown.expectAssertionError("check node at index 2");
        this.thrown.expectAssertionError(String.format("Expecting:%n <entry>%nto have attribute:%n <attr1>%nwith value:%n <value1>", new Object[0]));
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><feed>   <title>title</title>   <entry attr1=\"value1\" attr2=\"value2\">       <title>title1</title>   </entry>   <entry attr1=\"value1\" attr2=\"value2\">       <title>title1</title>   </entry>   <entry attr1=\"VALUE1\" attr2=\"value2\">       <title>title1</title>   </entry>   <entry attr1=\"value1\" attr2=\"value2\">       <title>title1</title>   </entry></feed>";
        XmlAssert.assertThat((Object)xml).nodesByXPath("/feed/entry").haveAttribute("attr1", "value1").haveAttribute("attr2", "value2");
    }

    @Test
    public void testHaveAttribute_withMultipleAttributeWithValues_shouldUseCustomFailMessage() {
        this.thrown.expectAssertionError("Alarm alarm!");
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><feed>   <title>title</title>   <entry attr1=\"value1\" attr2=\"value2\">       <title>title1</title>   </entry>   <entry attr1=\"value1\" attr2=\"value2\">       <title>title1</title>   </entry>   <entry attr1=\"VALUE1\" attr2=\"value2\">       <title>title1</title>   </entry>   <entry attr1=\"value1\" attr2=\"value2\">       <title>title1</title>   </entry></feed>";
        ((XmlAssert)XmlAssert.assertThat((Object)xml).withFailMessage("Alarm alarm!", new Object[0])).nodesByXPath("/feed/entry").haveAttribute("attr1", "value1").haveAttribute("attr2", "value2");
    }

    @Test
    public void testHaveAttribute_forEmptyNodeSet_shouldPass() {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><feed>   <title>title</title>   <entry attr1=\"value1\" attr2=\"value2\">       <title>title1</title>   </entry>   <entry attr1=\"value1\" attr2=\"value2\">       <title>title1</title>   </entry></feed>";
        XmlAssert.assertThat((Object)xml).nodesByXPath("/feed/abc").haveAttribute("attr1").haveAttribute("attr2", "value2");
    }
}

