/*
 * Decompiled with CFR 0.152.
 */
package org.xmlunit.assertj3;

import org.junit.Rule;
import org.junit.Test;
import org.xmlunit.assertj3.ExpectedException;
import org.xmlunit.assertj3.XmlAssert;

public class MultipleNodeAssertTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testContainsAnyNodeHavingXPath_shouldPass() {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><feed>   <title>title</title>   <entry attr=\"value\">       <title>title1</title>   </entry>   <entry attr=\"value2\">       <title>title1</title>   </entry></feed>";
        XmlAssert.assertThat((Object)xml).nodesByXPath("/feed/entry").containsAnyNodeHavingXPath("self::node()[@attr='value2']").containsAnyNodeHavingXPath("./title");
    }

    @Test
    public void testContainsAnyNodeHavingXPath_shouldFail() {
        this.thrown.expectAssertionError(String.format("Expecting:%nany node in set have XPath: <self::node()[@attrA]>", new Object[0]));
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><feed>   <title>title</title>   <entry attr=\"value\">       <title>title1</title>   </entry>   <entry attr2=\"value2\">       <title>title1</title>   </entry></feed>";
        XmlAssert.assertThat((Object)xml).hasXPath("/feed/entry").containsAnyNodeHavingXPath("self::node()[@attrA]");
    }

    @Test
    public void testContainsAnyNodeHavingXPath_shouldUseCustomFailMessage() {
        this.thrown.expectAssertionError("Alarm alarm!");
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><feed>   <title>title</title>   <entry attr=\"value\">       <title>title1</title>   </entry>   <entry attr2=\"value2\">       <title>title1</title>   </entry></feed>";
        ((XmlAssert)XmlAssert.assertThat((Object)xml).withFailMessage("Alarm alarm!", new Object[0])).hasXPath("/feed/entry").containsAnyNodeHavingXPath("self::node()[@attrA]");
    }

    @Test
    public void testContainsAllNodesHavingXPath_shouldPass() {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><feed>   <title>title</title>   <entry attr=\"value\">       <title>title1</title>   </entry>   <entry attr=\"value2\">       <title>title1</title>   </entry></feed>";
        XmlAssert.assertThat((Object)xml).nodesByXPath("/feed/entry").containsAllNodesHavingXPath("self::node()[@attr]").containsAllNodesHavingXPath("./title");
    }

    @Test
    public void testContainsAllNodesHavingXPath_shouldFail() {
        this.thrown.expectAssertionError("check node at index 2");
        this.thrown.expectAssertionError(String.format("Expecting:%n <entry>%nto have XPath: <./title>", new Object[0]));
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><feed>   <title>title</title>   <entry>       <title>title1</title>   </entry>   <entry>       <title>title1</title>   </entry>   <entry>       <description>description</description>   </entry></feed>";
        XmlAssert.assertThat((Object)xml).hasXPath("/feed/entry").containsAllNodesHavingXPath("./title");
    }

    @Test
    public void testContainsAllNodesHavingXPath_shouldUseCustomFailMessage() {
        this.thrown.expectAssertionError("Alarm alarm!");
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><feed>   <title>title</title>   <entry>       <title>title1</title>   </entry>   <entry>       <title>title1</title>   </entry>   <entry>       <description>description</description>   </entry></feed>";
        ((XmlAssert)XmlAssert.assertThat((Object)xml).withFailMessage("Alarm alarm!", new Object[0])).hasXPath("/feed/entry").containsAllNodesHavingXPath("./title");
    }

    @Test
    public void testExtractingAttribute_shouldPass() {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><feed>   <title>title</title>   <entry attr1=\"value1\" />   <entry attr1=\"value2\"/>   <entry />   <entry attr1=\"value4\" /></feed>";
        XmlAssert.assertThat((Object)xml).nodesByXPath("/feed/entry").extractingAttribute("attr1").containsExactly((Object[])new String[]{"value1", "value2", null, "value4"});
    }

    @Test
    public void testExtractingAttribute_shouldFail() {
        this.thrown.expectAssertionError("[XPath \"/feed/entry\" evaluated to node set] ");
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><feed>   <title>title</title>   <entry attr1=\"value1\" />   <entry attr1=\"value2\"/>   <entry />   <entry attr1=\"value4\" /></feed>";
        XmlAssert.assertThat((Object)xml).nodesByXPath("/feed/entry").extractingAttribute("attr1").containsExactly((Object[])new String[]{"value1", "value2", "value3", "value4"});
    }

    @Test
    public void testExtractingAttribute_shouldUseCustomErrorMessage() {
        this.thrown.expectAssertionError("Alarm alarm!");
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><feed>   <title>title</title>   <entry attr1=\"value1\" />   <entry attr1=\"value2\"/>   <entry />   <entry attr1=\"value4\" /></feed>";
        ((XmlAssert)XmlAssert.assertThat((Object)xml).withFailMessage("Alarm alarm!", new Object[0])).nodesByXPath("/feed/entry").extractingAttribute("attr1").containsExactly((Object[])new String[]{"value1", "value2", "value3", "value4"});
    }

    @Test
    public void testExtractingTextSingleNode_shouldPass() {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><feed>   <title>My Simple Feed</title>   <entry attr1=\"value1\" />   <entry attr1=\"value2\"/>   <entry />   <entry attr1=\"value4\" /></feed>";
        XmlAssert.assertThat((Object)xml).nodesByXPath("/feed/title").extractingText().containsExactly((Object[])new String[]{"My Simple Feed"});
    }

    @Test
    public void testExtractingTextSingleNodeWithWhiteSpace_shouldPass() {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><feed>   <title>           My Simple Feed   </title>   <entry attr1=\"value1\" />   <entry attr1=\"value2\"/>   <entry />   <entry attr1=\"value4\" /></feed>";
        XmlAssert.assertThat((Object)xml).nodesByXPath("/feed/title").extractingText().containsExactly((Object[])new String[]{"My Simple Feed"});
    }

    @Test
    public void testExtractingTextMultipleNodes_shouldPass() {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><document>   <h2> A header</h2> <h2>Just another header</h2></document>";
        XmlAssert.assertThat((Object)xml).nodesByXPath("/document/h2").extractingText().containsExactly((Object[])new String[]{"A header", "Just another header"});
    }

    @Test
    public void testExtractingTextMultipleNodesOneEmpty_shouldPass() {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><document>   <h2> A header</h2> <h2/></document>";
        XmlAssert.assertThat((Object)xml).nodesByXPath("/document/h2").extractingText().containsExactly((Object[])new String[]{"A header", ""});
    }

    @Test
    public void testExtractingTextMultipleNodes_shouldFail() {
        this.thrown.expectAssertionError("[XPath \"/document/h2\" evaluated to node set] ");
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><document>   <h2> Matching header</h2> <h2>Not matching</h2></document>";
        XmlAssert.assertThat((Object)xml).nodesByXPath("/document/h2").extractingText().containsExactly((Object[])new String[]{"Matching header", "Header not matching"});
    }

    @Test
    public void testExtractingTextMultipleNodes_shouldUseCustomFailMessage() {
        this.thrown.expectAssertionError("Alarm alarm!");
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><document>   <h2> Matching header</h2> <h2>Not matching</h2></document>";
        ((XmlAssert)XmlAssert.assertThat((Object)xml).withFailMessage("Alarm alarm!", new Object[0])).nodesByXPath("/document/h2").extractingText().containsExactly((Object[])new String[]{"Matching header", "Header not matching"});
    }
}

