/*
 * Decompiled with CFR 0.152.
 */
package org.xmlunit.assertj3;

import org.junit.Rule;
import org.junit.Test;
import org.xmlunit.assertj3.ExpectedException;
import org.xmlunit.assertj3.SingleNodeAssert;
import org.xmlunit.assertj3.XmlAssert;

public class SingleNodeAssertDoesNotHaveAttributeTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testDoesNotHaveAttribute_forNodeWithoutAttribute_shouldPass() {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><feed>   <title>title</title>   <entry attr=\"value\">       <title>title1</title>   </entry></feed>";
        ((SingleNodeAssert)XmlAssert.assertThat((Object)xml).nodesByXPath("/feed/title").first()).doesNotHaveAttribute("attr");
    }

    @Test
    public void testDoesNotHaveAttribute_withValue_forNodeWithoutAttribute_shouldPass() {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><feed>   <title>title</title>   <entry attr=\"value\">       <title>title1</title>   </entry></feed>";
        ((SingleNodeAssert)XmlAssert.assertThat((Object)xml).nodesByXPath("/feed/title").first()).doesNotHaveAttribute("attr", "value");
    }

    @Test
    public void testDoesNotHaveAttribute_forNodeWithAttribute_shouldPass() {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><feed>   <title>title</title>   <entry abc=\"value\">       <title>title1</title>   </entry></feed>";
        ((SingleNodeAssert)XmlAssert.assertThat((Object)xml).nodesByXPath("/feed/title").first()).doesNotHaveAttribute("attr");
    }

    @Test
    public void testDoesNotHaveAttribute_withValue_forNodeWithAttribute_shouldPass() {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><feed>   <title>title</title>   <entry attr=\"abc\">       <title>title1</title>   </entry></feed>";
        ((SingleNodeAssert)XmlAssert.assertThat((Object)xml).nodesByXPath("/feed/title").first()).doesNotHaveAttribute("attr", "value");
    }

    @Test
    public void testDoesNotHaveAttribute_forNodeWithMultipleAttributes_shouldPass() {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><feed>   <title>title</title>   <entry abc=\"value1\" xyz=\"value2\">       <title>title1</title>   </entry></feed>";
        ((SingleNodeAssert)XmlAssert.assertThat((Object)xml).nodesByXPath("/feed/entry").first()).doesNotHaveAttribute("attr1").doesNotHaveAttribute("attr2");
    }

    @Test
    public void testDoesNotHaveAttribute_withValue_forNodeWithMultipleAttributes_shouldPass() {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><feed>   <title>title</title>   <entry attr1=\"abc\" attr2=\"xyz\">       <title>title1</title>   </entry></feed>";
        ((SingleNodeAssert)XmlAssert.assertThat((Object)xml).nodesByXPath("/feed/entry").first()).doesNotHaveAttribute("attr1", "value1").doesNotHaveAttribute("attr2", "value2");
    }

    @Test
    public void testDoesNotHaveAttribute_withMultipleMatchingNodes_shouldPass() {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><feed>   <entry attr1=\"xyz\">       <title>title1</title>   </entry>   <entry attr2=\"abc\">       <title>title1</title>   </entry>   <entry attr5=\"value3\">       <title>title1</title>   </entry>   <entry attr4=\"value2\">       <title>title1</title>   </entry></feed>";
        ((SingleNodeAssert)XmlAssert.assertThat((Object)xml).nodesByXPath("/feed/entry").first()).doesNotHaveAttribute("attr1", "value1");
        ((SingleNodeAssert)XmlAssert.assertThat((Object)xml).nodesByXPath("/feed/entry").last()).doesNotHaveAttribute("attr4", "value4");
        ((SingleNodeAssert)XmlAssert.assertThat((Object)xml).nodesByXPath("/feed/entry").element(2)).doesNotHaveAttribute("attr3", "value3");
    }

    @Test
    public void testDoesNotHaveAttribute_withAnyValue_shouldFailed() {
        this.thrown.expectAssertionError(String.format("Expecting:%n <entry>%nnot to have attribute:%n <attr>", new Object[0]));
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><feed>   <title>title</title>   <entry attr=\"value\">       <title>title1</title>   </entry></feed>";
        ((SingleNodeAssert)XmlAssert.assertThat((Object)xml).nodesByXPath("/feed/entry").first()).doesNotHaveAttribute("attr");
    }

    @Test
    public void testDoesNotHaveAttribute_withValue_shouldFailed() {
        this.thrown.expectAssertionError(String.format("Expecting:%n <entry>%nnot to have attribute:%n <attr>%nwith value:%n <value>", new Object[0]));
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><feed>   <title>title</title>   <entry attr=\"value\">       <title>title1</title>   </entry></feed>";
        ((SingleNodeAssert)XmlAssert.assertThat((Object)xml).nodesByXPath("/feed/entry").first()).doesNotHaveAttribute("attr", "value");
    }

    @Test
    public void testDoesNotHaveAttribute_withMultipleAttributes_shouldFailed() {
        this.thrown.expectAssertionError(String.format("Expecting:%n <entry>%nnot to have attribute:%n <attr2>%nwith value:%n <value2>", new Object[0]));
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><feed>   <title>title</title>   <entry attr1=\"abc\" attr2=\"value2\">       <title>title1</title>   </entry></feed>";
        ((SingleNodeAssert)XmlAssert.assertThat((Object)xml).nodesByXPath("/feed/entry").first()).doesNotHaveAttribute("attr1", "value1").doesNotHaveAttribute("attr2", "value2");
    }

    @Test
    public void testDoesNotHaveAttribute_forFirstNode_shouldFailed() {
        this.thrown.expectAssertionError(String.format("Expecting:%n <entry>%nnot to have attribute:%n <attr1>%nwith value:%n <value1>", new Object[0]));
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><feed>   <entry attr1=\"value1\">       <title>title1</title>   </entry>   <entry attr2=\"value2\">       <title>title1</title>   </entry></feed>";
        ((SingleNodeAssert)XmlAssert.assertThat((Object)xml).nodesByXPath("/feed/entry").first()).doesNotHaveAttribute("attr1", "value1");
    }

    @Test
    public void testDoesNotHaveAttribute_forLastNode_shouldFailed() {
        this.thrown.expectAssertionError(String.format("Expecting:%n <entry>%nnot to have attribute:%n <attr2>%nwith value:%n <value2>", new Object[0]));
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><feed>   <entry attr1=\"value1\">       <title>title1</title>   </entry>   <entry attr2=\"value2\">       <title>title1</title>   </entry></feed>";
        ((SingleNodeAssert)XmlAssert.assertThat((Object)xml).nodesByXPath("/feed/entry").last()).doesNotHaveAttribute("attr2", "value2");
    }
}

