/*
 * Decompiled with CFR 0.152.
 */
package org.xmlunit.assertj3;

import org.junit.Rule;
import org.junit.Test;
import org.xmlunit.assertj3.ExpectedException;
import org.xmlunit.assertj3.SingleNodeAssert;
import org.xmlunit.assertj3.XmlAssert;

public class SingleNodeAssertTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testHasXPath_shouldPass() {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><feed>   <title>title</title>   <entry attr=\"value\">       <title>title1</title>   </entry></feed>";
        ((SingleNodeAssert)XmlAssert.assertThat((Object)xml).nodesByXPath("/feed/entry").first()).hasXPath("./title").hasXPath("self::node()[@attr]").hasXPath("self::node()[@attr='value']");
    }

    @Test
    public void testHasXPath_shouldFailed() {
        this.thrown.expectAssertionError(String.format("Expecting:%n <entry>%nto have XPath: <./abc>", new Object[0]));
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><feed>   <title>title</title>   <entry attr=\"value\">       <title>title1</title>   </entry></feed>";
        ((SingleNodeAssert)XmlAssert.assertThat((Object)xml).nodesByXPath("/feed/entry").first()).hasXPath("./abc");
    }
}

