/*
 * Decompiled with CFR 0.152.
 */
package org.xmlunit.assertj3;

import java.util.HashMap;
import org.junit.Rule;
import org.junit.Test;
import org.xmlunit.assertj3.ExpectedException;
import org.xmlunit.assertj3.XmlAssert;

public class XmlAssertDoesNotHaveXPathTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testDoesNotHaveXPath_withNotExistingXPath_shouldPass() {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><fruits>   <fruit name=\"apple\"/>   <fruit name=\"orange\"/>   <fruit name=\"banana\"/></fruits>";
        XmlAssert.assertThat((Object)xml).doesNotHaveXPath("//entry/id");
    }

    @Test
    public void testDoesNotHaveXPath_withExistingXPath_shouldFailed() {
        this.thrown.expectAssertionError("Expecting empty but was");
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><fruits>   <fruit name=\"apple\"/>   <fruit name=\"orange\"/>   <fruit name=\"banana\"/></fruits>";
        XmlAssert.assertThat((Object)xml).doesNotHaveXPath("/fruits/fruit");
    }

    @Test
    public void testDoesNotHaveXPath_withAttribute_shouldPass() {
        String xml = "<a><b attr=\"abc\"></b></a>";
        XmlAssert.assertThat((Object)xml).doesNotHaveXPath("//a/b[@attr=\"xyz\"]");
    }

    @Test
    public void testDoesNotHaveXPath_withAttribute_shouldFailed() {
        this.thrown.expectAssertionError("Expecting empty but was");
        String xml = "<a><b attr=\"abc\"></b></a>";
        XmlAssert.assertThat((Object)xml).doesNotHaveXPath("//a/b[@attr=\"abc\"]");
    }

    @Test
    public void testDoesNotHaveXPath_withNamespacesContext_shouldPass() {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><feed xmlns=\"http://www.w3.org/2005/Atom\">   <title>title</title>   <entry>       <title>title1</title>       <id>id1</id>   </entry></feed>";
        HashMap<String, String> prefix2Uri = new HashMap<String, String>();
        prefix2Uri.put("atom", "http://www.w3.org/2005/Atom");
        XmlAssert.assertThat((Object)xml).withNamespaceContext(prefix2Uri).doesNotHaveXPath("//atom:feed/atom:entry/atom:description");
    }

    @Test
    public void testDoesNotHaveXPath_withInvalidXML_shouldFailed() {
        this.thrown.expectAssertionError("Expecting code not to raise a throwable but caught");
        String xml = "<b>not empty</a>";
        XmlAssert.assertThat((Object)xml).doesNotHaveXPath("//atom:feed/atom:entry/atom:id");
    }
}

