/*
 * Decompiled with CFR 0.152.
 */
package org.xmlunit.assertj3;

import java.io.StringReader;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.junit.Rule;
import org.junit.Test;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xmlunit.assertj3.ExpectedException;
import org.xmlunit.assertj3.XmlAssert;

public class XmlAssertHasXPathTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testHasXPath_onElementType_withSingleMatching_shouldPass() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><feed>   <title>title</title>   <entry>       <title>title1</title>       <id>id1</id>   </entry></feed>";
        DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Element rootElement = documentBuilder.parse(new InputSource(new StringReader(xml))).getDocumentElement();
        XmlAssert.assertThat((Object)rootElement).hasXPath("entry/id");
        XmlAssert.assertThat((Object)rootElement).hasXPath("/feed/title");
    }

    @Test
    public void testHasXPath_onStringType_withSingleMatching_shouldPass() {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><feed>   <title>title</title>   <entry>       <title>title1</title>       <id>id1</id>   </entry></feed>";
        XmlAssert.assertThat((Object)xml).hasXPath("//entry/id");
        XmlAssert.assertThat((Object)xml).hasXPath("/feed/entry/id");
    }

    @Test
    public void testHasXPath_withNotExistingXPath_shouldFailed() {
        this.thrown.expectAssertionError("Expecting actual not to be empty");
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><feed>   <title>title</title>   <entry>       <title>title1</title>       <id>id1</id>   </entry></feed>";
        XmlAssert.assertThat((Object)xml).hasXPath("//entry/description");
    }

    @Test
    public void testHasXPath_withMultipleMatching_shouldPass() {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><feed>   <title>title</title>   <entry>       <title>title1</title>       <id>id1</id>   </entry>   <entry>       <title>title2</title>       <id>id2</id>   </entry></feed>";
        XmlAssert.assertThat((Object)xml).hasXPath("//entry/id");
        XmlAssert.assertThat((Object)xml).hasXPath("/feed/entry/title");
    }

    @Test
    public void testHasXPath_withAttribute_shouldPass() {
        String xml = "<a><b attr=\"abc\"></b></a>";
        XmlAssert.assertThat((Object)xml).hasXPath("//a/b[@attr=\"abc\"]");
    }

    @Test
    public void testHasXPath_withAttribute_shouldFailed() {
        this.thrown.expectAssertionError("Expecting actual not to be empty");
        String xml = "<a><b attr=\"abc\"></b></a>";
        XmlAssert.assertThat((Object)xml).hasXPath("//a/b[@attr=\"abcde\"]");
    }

    @Test
    public void testHasXPath_withNamespacesContext_shouldPass() {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><feed xmlns=\"http://www.w3.org/2005/Atom\">   <title>title</title>   <entry>       <title>title1</title>       <id>id1</id>   </entry></feed>";
        HashMap<String, String> prefix2Uri = new HashMap<String, String>();
        prefix2Uri.put("atom", "http://www.w3.org/2005/Atom");
        XmlAssert.assertThat((Object)xml).withNamespaceContext(prefix2Uri).hasXPath("//atom:feed/atom:entry/atom:id");
        XmlAssert.assertThat((Object)xml).withNamespaceContext(prefix2Uri).hasXPath("//atom:feed/atom:entry/atom:title");
    }

    @Test
    public void testHasXPath_withDocumentBuilderFactory_shouldPass() {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><feed>   <entry>       <title>title1</title>       <id>id1</id>   </entry></feed>";
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        XmlAssert.assertThat((Object)xml).withDocumentBuilderFactory(dbf).hasXPath("//entry/title");
    }

    @Test
    public void testHasXPath_withInvalidNamespacesContext_shouldFailed() {
        this.thrown.expectAssertionError("Expecting actual not to be empty");
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><feed xmlns=\"http://www.w3.org/2005/Atom\">   <title>title</title>   <entry>       <title>title1</title>       <id>id1</id>   </entry></feed>";
        HashMap<String, String> prefix2Uri = new HashMap<String, String>();
        prefix2Uri.put("atom", "http://www.w3.org/2005/ATOM");
        XmlAssert.assertThat((Object)xml).withNamespaceContext(prefix2Uri).hasXPath("//atom:feed/atom:entry/atom:id");
    }

    @Test
    public void testHasXPath_withInvalidXML_shouldFailed() {
        this.thrown.expectAssertionError("Expecting code not to raise a throwable but caught");
        String xml = "<b>not empty</a>";
        XmlAssert.assertThat((Object)xml).hasXPath("//atom:feed/atom:entry/atom:id");
    }
}

