/*
 * Decompiled with CFR 0.152.
 */
package org.xmlunit.assertj3;

import org.junit.Rule;
import org.junit.Test;
import org.xmlunit.assertj3.AssertionsAdapter;
import org.xmlunit.assertj3.ExpectedException;
import org.xmlunit.assertj3.MultipleNodeAssert;
import org.xmlunit.assertj3.XmlAssert;

public class XmlAssertNodesByXPathTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testXPath_shouldReturnNotNull() {
        MultipleNodeAssert multipleNodeAssert1 = XmlAssert.assertThat((Object)"<a><b></b><c/></a>").nodesByXPath("/a");
        MultipleNodeAssert multipleNodeAssert2 = XmlAssert.assertThat((Object)"<a><b></b><c/></a>").nodesByXPath("/x");
        AssertionsAdapter.assertThat((Object)multipleNodeAssert1).isNotNull();
        AssertionsAdapter.assertThat((Object)multipleNodeAssert2).isNotNull();
    }

    @Test
    public void testAssertThat_withNull_shouldFailed() {
        this.thrown.expectAssertionError(String.format("%nExpecting actual not to be null", new Object[0]));
        XmlAssert.assertThat(null).nodesByXPath("//foo");
    }

    @Test
    public void testNodesByXPath_withNull_shouldFail() {
        this.thrown.expectAssertionErrorPattern(String.format("%nExpecting not blank but was:(<| )null>?", new Object[0]));
        XmlAssert.assertThat((Object)"<a><b></b><c/></a>").nodesByXPath(null);
    }

    @Test
    public void testNodesByXPath_withWhitespacesOnly_shouldFail() {
        this.thrown.expectAssertionErrorPattern(String.format("%nExpecting not blank but was:(<| )\" \n \t\">?", new Object[0]));
        XmlAssert.assertThat((Object)"<a><b></b><c/></a>").nodesByXPath(" \n \t");
    }

    @Test
    public void testNodesByXPath_withInvalidXML_shouldFailed() {
        this.thrown.expectAssertionError("Expecting code not to raise a throwable but caught");
        String xml = "<b>not empty</a>";
        XmlAssert.assertThat((Object)xml).nodesByXPath("//atom:feed/atom:entry/atom:id");
    }

    @Test
    public void nodesByXPath_withInvalidXPath_shouldFail() {
        this.thrown.expectAssertionError(String.format("%nExpecting code not to raise a throwable but caught", new Object[0]));
        XmlAssert.assertThat((Object)"<a><b></b><c/></a>").nodesByXPath("this doesn't look like an XPath expression :-(");
    }
}

