/*
 * Decompiled with CFR 0.152.
 */
package org.xmlunit.assertj3;

import java.io.File;
import java.util.regex.Pattern;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.xmlunit.assertj3.ExpectedException;
import org.xmlunit.assertj3.XmlAssert;
import org.xmlunit.assertj3.util.SetEnglishLocaleRule;

public class XmlAssertValidationTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    @ClassRule
    public static SetEnglishLocaleRule locale = new SetEnglishLocaleRule();

    @Test
    public void testIsValidAgainst_shouldPass() {
        StreamSource xml = new StreamSource(new File("../test-resources/BookXsdGenerated.xml"));
        StreamSource xsd = new StreamSource(new File("../test-resources/Book.xsd"));
        XmlAssert.assertThat((Object)xml).isValidAgainst(new Object[]{xsd});
    }

    @Test
    public void testIsValidAgainst_withExternallyCreatedSchemaInstance_shouldPass() throws Exception {
        StreamSource xml = new StreamSource(new File("../test-resources/BookXsdGenerated.xml"));
        StreamSource xsd = new StreamSource(new File("../test-resources/Book.xsd"));
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = factory.newSchema(xsd);
        XmlAssert.assertThat((Object)xml).isValidAgainst(schema);
    }

    @Test
    public void testIsNotValidAgainst_withBrokenXml_shouldPass() {
        StreamSource xml = new StreamSource(new File("../test-resources/invalidBook.xml"));
        StreamSource xsd = new StreamSource(new File("../test-resources/Book.xsd"));
        XmlAssert.assertThat((Object)xml).isNotValidAgainst(new Object[]{xsd});
    }

    @Test
    public void testIsNotValidAgainst_withBrokenXml_andExternallyCreatedSchemaInstance_shouldPass() throws Exception {
        StreamSource xml = new StreamSource(new File("../test-resources/invalidBook.xml"));
        StreamSource xsd = new StreamSource(new File("../test-resources/Book.xsd"));
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = factory.newSchema(xsd);
        XmlAssert.assertThat((Object)xml).isNotValidAgainst(schema);
    }

    @Test
    public void testIsValidAgainst_withBrokenXml_shouldFail() {
        this.thrown.expectAssertionErrorPattern("^\\RExpecting:\\R <.*" + Pattern.quote("../test-resources/") + "invalidBook.xml>\\Rto be valid but found following problems:\\R.*");
        this.thrown.expectAssertionError("1. line=9; column=8; type=ERROR; message=cvc-complex-type.2.4.b: The content of element 'Book' is not complete. One of '{\"https://www.xmlunit.org/publishing\":Publisher}' is expected.");
        StreamSource xml = new StreamSource(new File("../test-resources/invalidBook.xml"));
        StreamSource xsd = new StreamSource(new File("../test-resources/Book.xsd"));
        XmlAssert.assertThat((Object)xml).isValidAgainst(new Object[]{xsd});
    }

    @Test
    public void isValidAgainstUsesCustomFailMessage() {
        this.thrown.expectAssertionError("Alarm alarm!");
        StreamSource xml = new StreamSource(new File("../test-resources/invalidBook.xml"));
        StreamSource xsd = new StreamSource(new File("../test-resources/Book.xsd"));
        ((XmlAssert)XmlAssert.assertThat((Object)xml).withFailMessage("Alarm alarm!", new Object[0])).isValidAgainst(new Object[]{xsd});
    }

    @Test
    public void testIsValidAgainst_withEmptySourcesArray_shouldPass() {
        StreamSource xml = new StreamSource(new File("../test-resources/BookXsdGenerated.xml"));
        XmlAssert.assertThat((Object)xml).isValidAgainst(new Object[0]);
        XmlAssert.assertThat((Object)xml).isValidAgainst(new Object[0]);
    }

    @Test
    public void testIsValidAgainst_withBrokenXmlAndEmptySourcesArray_shouldFail() {
        this.thrown.expectAssertionError("1. line=9; column=8; type=ERROR; message=cvc-complex-type.2.4.b: The content of element 'Book' is not complete. One of '{\"https://www.xmlunit.org/publishing\":Publisher}' is expected.");
        StreamSource xml = new StreamSource(new File("../test-resources/invalidBook.xml"));
        XmlAssert.assertThat((Object)xml).isValidAgainst(new Object[0]);
    }

    @Test
    public void testIsValidAgainst_withBrokenXmlAndEmptySourcesArray_shouldUseCustomFailMessage() {
        this.thrown.expectAssertionError("Alarm alarm!");
        StreamSource xml = new StreamSource(new File("../test-resources/invalidBook.xml"));
        ((XmlAssert)XmlAssert.assertThat((Object)xml).withFailMessage("Alarm alarm!", new Object[0])).isValidAgainst(new Object[0]);
    }

    @Test
    public void testIsValid_shouldPass() {
        StreamSource xml = new StreamSource(new File("../test-resources/BookXsdGenerated.xml"));
        XmlAssert.assertThat((Object)xml).isValid();
    }

    @Test
    public void testIsValid_withBrokenXml_shouldPass() {
        this.thrown.expectAssertionError("1. line=9; column=8; type=ERROR; message=cvc-complex-type.2.4.b: The content of element 'Book' is not complete. One of '{\"https://www.xmlunit.org/publishing\":Publisher}' is expected.");
        StreamSource xml = new StreamSource(new File("../test-resources/invalidBook.xml"));
        XmlAssert.assertThat((Object)xml).isValid();
    }

    @Test
    public void testIsInvalid_withBrokenXml_shouldPass() {
        StreamSource xml = new StreamSource(new File("../test-resources/invalidBook.xml"));
        XmlAssert.assertThat((Object)xml).isInvalid();
    }

    @Test
    public void testIsInvalid_shouldFail() {
        this.thrown.expectAssertionErrorPattern("^\\RExpecting:\\R <.*" + Pattern.quote("../test-resources/") + "BookXsdGenerated.xml>\\Rto be invalid");
        StreamSource xml = new StreamSource(new File("../test-resources/BookXsdGenerated.xml"));
        XmlAssert.assertThat((Object)xml).isInvalid();
    }

    @Test
    public void testIsInvalidUsesCustomFailMessage() {
        this.thrown.expectAssertionError("Alarm alarm!");
        StreamSource xml = new StreamSource(new File("../test-resources/BookXsdGenerated.xml"));
        ((XmlAssert)XmlAssert.assertThat((Object)xml).withFailMessage("Alarm alarm!", new Object[0])).isInvalid();
    }

    @Test
    public void testIsValidAgainst_withNullSchemaSources_shouldFail() {
        this.thrown.expectAssertionError("actual not to be null");
        StreamSource xml = new StreamSource(new File("../test-resources/BookXsdGenerated.xml"));
        XmlAssert.assertThat((Object)xml).isValidAgainst((Object[])null);
    }

    @Test
    public void testIsValidAgainst_withNullSchema_shouldFail() {
        this.thrown.expectAssertionError("actual not to be null");
        StreamSource xml = new StreamSource(new File("../test-resources/BookXsdGenerated.xml"));
        XmlAssert.assertThat((Object)xml).isValidAgainst((Schema)null);
    }
}

