/*
 * Decompiled with CFR 0.152.
 */
package org.xmlunit.assertj3;

import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.xmlunit.assertj3.ExpectedException;
import org.xmlunit.assertj3.XmlAssert;
import org.xmlunit.assertj3.util.SetEnglishLocaleRule;

public class XmlAssertValueByXPathTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    @ClassRule
    public static SetEnglishLocaleRule locale = new SetEnglishLocaleRule();

    @Test
    public void testValueByXPath_withNull_shouldFail() {
        this.thrown.expectAssertionErrorPattern(String.format("%nExpecting not blank but was:(<| )null>?", new Object[0]));
        XmlAssert.assertThat((Object)"<a><b></b><c/></a>").valueByXPath(null);
    }

    @Test
    public void testValueByXPath_withWhitespacesOnly_shouldFailed() {
        this.thrown.expectAssertionErrorPattern(String.format("%nExpecting not blank but was:(<| )\" \n \t\">?", new Object[0]));
        XmlAssert.assertThat((Object)"<a><b></b><c/></a>").valueByXPath(" \n \t");
    }

    @Test
    public void testValueByXpath_withInvalidXml_shouldFailed() {
        this.thrown.expectAssertionErrorPattern(".*Expecting code not to raise a throwable but caught.*Content is not allowed in prolog.*");
        XmlAssert.assertThat((Object)"not empty").valueByXPath("count(//atom:feed/atom:entry)");
    }

    @Test
    public void valueByXPath_withInvalidXPath_shouldFail() {
        this.thrown.expectAssertionError(String.format("%nExpecting code not to raise a throwable but caught", new Object[0]));
        XmlAssert.assertThat((Object)"<a><b></b><c/></a>").valueByXPath("this doesn't look like an XPath expression :-(");
    }
}

