/*
 * Decompiled with CFR 0.152.
 */
package org.custommonkey.xmlunit;

import java.io.StringReader;
import java.io.StringWriter;
import java.util.Iterator;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.custommonkey.xmlunit.NamespaceContext;
import org.custommonkey.xmlunit.SimpleNamespaceContext;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XSLTConstants;
import org.custommonkey.xmlunit.XpathEngine;
import org.custommonkey.xmlunit.exceptions.ConfigurationException;
import org.custommonkey.xmlunit.exceptions.XpathException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SimpleXpathEngine
implements XpathEngine,
XSLTConstants {
    private NamespaceContext ctx = SimpleNamespaceContext.EMPTY_CONTEXT;

    private StringBuffer getXSLTBase() {
        StringBuffer result = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>").append(XMLUnit.getXSLTStart());
        String tmp = result.toString();
        int close = tmp.lastIndexOf(62);
        if (close == -1) {
            close = tmp.length();
        }
        result.insert(close, this.getNamespaceDeclarations());
        return result;
    }

    private String getCopyTransformation(String select) {
        return this.getXSLTBase().append("<xsl:preserve-space elements=\"*\"/>").append("<xsl:output method=\"xml\" version=\"1.0\" encoding=\"UTF-8\"/>").append("<xsl:template match=\"/\">").append("<xpathResult>").append("<xsl:apply-templates select=\"").append(select).append("\" mode=\"result\"/>").append("</xpathResult>").append("</xsl:template>").append("<xsl:template match=\"*\" mode=\"result\">").append("  <xsl:copy-of select=\".\"/>").append("</xsl:template>").append("</xsl:stylesheet>").toString();
    }

    private String getValueTransformation(String select) {
        return this.getXSLTBase().append("<xsl:output method=\"text\"/>").append("<xsl:template match=\"/\">").append("  <xsl:value-of select=\"").append(select).append("\"/>").append("</xsl:template>").append("</xsl:stylesheet>").toString();
    }

    private void performTransform(String xslt, Document document, Result result) throws TransformerException, ConfigurationException, XpathException {
        try {
            StreamSource source = new StreamSource(new StringReader(xslt));
            TransformerFactory tf = XMLUnit.newTransformerFactory();
            ErrorListener el = new ErrorListener(){

                @Override
                public void error(TransformerException ex) throws TransformerException {
                    throw ex;
                }

                @Override
                public void fatalError(TransformerException ex) throws TransformerException {
                    throw ex;
                }

                @Override
                public void warning(TransformerException ex) {
                    ex.printStackTrace();
                }
            };
            tf.setErrorListener(el);
            Transformer transformer = tf.newTransformer(source);
            if (transformer == null) {
                throw new XpathException("failed to obtain an XSLT transformer for XPath expression.");
            }
            transformer.setErrorListener(el);
            transformer.transform(new DOMSource(document), result);
        }
        catch (TransformerConfigurationException ex) {
            throw new ConfigurationException(ex);
        }
    }

    protected Node getXPathResultNode(String select, Document document) throws ConfigurationException, TransformerException, XpathException {
        return this.getXPathResultAsDocument(select, document).getDocumentElement();
    }

    protected Document getXPathResultAsDocument(String select, Document document) throws ConfigurationException, TransformerException, XpathException {
        DOMResult result = new DOMResult();
        this.performTransform(this.getCopyTransformation(select), document, result);
        return (Document)result.getNode();
    }

    @Override
    public NodeList getMatchingNodes(String select, Document document) throws ConfigurationException, XpathException {
        try {
            return this.getXPathResultNode(select, document).getChildNodes();
        }
        catch (TransformerException ex) {
            throw new XpathException("Failed to apply stylesheet", ex);
        }
    }

    @Override
    public String evaluate(String select, Document document) throws ConfigurationException, XpathException {
        try {
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            this.performTransform(this.getValueTransformation(select), document, result);
            return writer.toString();
        }
        catch (TransformerException ex) {
            throw new XpathException("Failed to apply stylesheet", ex);
        }
    }

    @Override
    public void setNamespaceContext(NamespaceContext ctx) {
        this.ctx = ctx;
    }

    private String getNamespaceDeclarations() {
        StringBuffer nsDecls = new StringBuffer();
        String quoteStyle = "'";
        Iterator keys = this.ctx.getPrefixes();
        while (keys.hasNext()) {
            String prefix = (String)keys.next();
            String uri = this.ctx.getNamespaceURI(prefix);
            if (uri == null) continue;
            if (prefix == null) {
                prefix = "";
            }
            if (uri.indexOf(39) != -1) {
                quoteStyle = "\"";
            }
            nsDecls.append(' ').append("xmlns");
            if (prefix.length() > 0) {
                nsDecls.append(':');
            }
            nsDecls.append(prefix).append('=').append(quoteStyle).append(uri).append(quoteStyle).append(' ');
        }
        return nsDecls.toString();
    }
}

