package org.xtext.gradle.builder;

import java.io.File;
import java.util.Collection;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtend.lib.annotations.FinalFieldsConstructor;
import org.eclipse.xtext.util.UriUtil;
import org.eclipse.xtext.workspace.IProjectConfig;
import org.eclipse.xtext.workspace.ISourceFolder;
import org.eclipse.xtext.workspace.IWorkspaceConfig;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.xtext.gradle.builder.GradleSourceFolder;
import org.xtext.gradle.builder.GradleWorkspaceConfig;
import org.xtext.gradle.protocol.GradleBuildRequest;

@FinalFieldsConstructor
@SuppressWarnings("all")
public class GradleProjectConfig implements IProjectConfig {
  private final GradleBuildRequest request;
  
  @Override
  public String getName() {
    return this.request.getProjectName();
  }
  
  @Override
  public URI getPath() {
    File _projectDir = this.request.getProjectDir();
    return UriUtil.createFolderURI(_projectDir);
  }
  
  @Override
  public Set<? extends ISourceFolder> getSourceFolders() {
    Collection<File> _sourceFolders = this.request.getSourceFolders();
    final Function1<File, GradleSourceFolder> _function = (File it) -> {
      GradleSourceFolder _xblockexpression = null;
      {
        final URI uri = UriUtil.createFolderURI(it);
        _xblockexpression = new GradleSourceFolder(this, uri);
      }
      return _xblockexpression;
    };
    Iterable<GradleSourceFolder> _map = IterableExtensions.<File, GradleSourceFolder>map(_sourceFolders, _function);
    return IterableExtensions.<GradleSourceFolder>toSet(_map);
  }
  
  @Override
  public ISourceFolder findSourceFolderContaining(final URI member) {
    Set<? extends ISourceFolder> _sourceFolders = this.getSourceFolders();
    final Function1<ISourceFolder, Boolean> _function = (ISourceFolder it) -> {
      URI _path = it.getPath();
      return Boolean.valueOf(UriUtil.isPrefixOf(_path, member));
    };
    return IterableExtensions.findFirst(_sourceFolders, _function);
  }
  
  @Override
  public IWorkspaceConfig getWorkspaceConfig() {
    return new GradleWorkspaceConfig(this);
  }
  
  public GradleProjectConfig(final GradleBuildRequest request) {
    super();
    this.request = request;
  }
}
