package org.xtext.gradle.builder;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.ISelectable;
import org.eclipse.xtext.resource.impl.ChunkedResourceDescriptions;
import org.eclipse.xtext.resource.impl.ProjectDescription;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsData;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.Functions.Function2;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.MapExtensions;

@SuppressWarnings("all")
public class GradleResourceDescriptions extends ChunkedResourceDescriptions {
  public GradleResourceDescriptions() {
  }
  
  public GradleResourceDescriptions(final Map<String, ResourceDescriptionsData> initialData, final ResourceSet resourceSet) {
    super(initialData);
    this.setResourceSet(resourceSet);
  }
  
  @Override
  public Iterable<IResourceDescription> getAllResourceDescriptions() {
    Collection<ResourceDescriptionsData> _visibleResourceDescriptions = this.getVisibleResourceDescriptions();
    final Function1<ResourceDescriptionsData, Iterable<IResourceDescription>> _function = (ResourceDescriptionsData it) -> {
      return it.getAllResourceDescriptions();
    };
    Iterable<Iterable<IResourceDescription>> _map = IterableExtensions.<ResourceDescriptionsData, Iterable<IResourceDescription>>map(_visibleResourceDescriptions, _function);
    return Iterables.<IResourceDescription>concat(_map);
  }
  
  @Override
  public IResourceDescription getResourceDescription(final URI uri) {
    Collection<ResourceDescriptionsData> _visibleResourceDescriptions = this.getVisibleResourceDescriptions();
    for (final ResourceDescriptionsData selectable : _visibleResourceDescriptions) {
      {
        final IResourceDescription result = selectable.getResourceDescription(uri);
        if ((result != null)) {
          return result;
        }
      }
    }
    return null;
  }
  
  @Override
  protected Iterable<? extends ISelectable> getSelectables() {
    return this.getVisibleResourceDescriptions();
  }
  
  private Collection<ResourceDescriptionsData> getVisibleResourceDescriptions() {
    Collection<ResourceDescriptionsData> _xblockexpression = null;
    {
      final ProjectDescription project = ProjectDescription.findInEmfObject(this.resourceSet);
      final Function2<String, ResourceDescriptionsData, Boolean> _function = (String key, ResourceDescriptionsData value) -> {
        boolean _or = false;
        List<String> _dependencies = project.getDependencies();
        boolean _contains = _dependencies.contains(key);
        if (_contains) {
          _or = true;
        } else {
          String _name = project.getName();
          boolean _equals = Objects.equal(_name, key);
          _or = _equals;
        }
        return Boolean.valueOf(_or);
      };
      Map<String, ResourceDescriptionsData> _filter = MapExtensions.<String, ResourceDescriptionsData>filter(this.chunk2resourceDescriptions, _function);
      _xblockexpression = _filter.values();
    }
    return _xblockexpression;
  }
  
  @Override
  public ChunkedResourceDescriptions createShallowCopyWith(final ResourceSet resourceSet) {
    return new GradleResourceDescriptions(this.chunk2resourceDescriptions, resourceSet);
  }
}
