package org.xtext.gradle.builder;

import org.eclipse.emf.common.util.URI;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.annotations.FinalFieldsConstructor;
import org.eclipse.xtext.workspace.ISourceFolder;
import org.eclipse.xtext.xbase.lib.Pure;
import org.xtext.gradle.builder.GradleProjectConfig;

@FinalFieldsConstructor
@SuppressWarnings("all")
public class GradleSourceFolder implements ISourceFolder {
  private final GradleProjectConfig parent;
  
  @Accessors
  private final URI path;
  
  @Override
  public String getName() {
    URI _path = this.parent.getPath();
    URI _deresolve = this.path.deresolve(_path);
    URI _trimSegments = _deresolve.trimSegments(1);
    return _trimSegments.path();
  }
  
  public GradleSourceFolder(final GradleProjectConfig parent, final URI path) {
    super();
    this.parent = parent;
    this.path = path;
  }
  
  @Pure
  public URI getPath() {
    return this.path;
  }
}
