package org.xtext.gradle.builder;

import org.eclipse.emf.common.util.URI;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.annotations.FinalFieldsConstructor;
import org.eclipse.xtext.build.BuildRequest;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.xbase.lib.Pure;
import org.gradle.api.logging.Logger;

@FinalFieldsConstructor
@SuppressWarnings("all")
public class GradleValidatonCallback implements BuildRequest.IPostValidationCallback {
  private final Logger logger;
  
  @Accessors
  private boolean errorFree = true;
  
  @Override
  public boolean afterValidate(final URI validated, final Iterable<Issue> issues) {
    for (final Issue issue : issues) {
      Severity _severity = issue.getSeverity();
      if (_severity != null) {
        switch (_severity) {
          case ERROR:
            String _string = issue.toString();
            this.logger.error(_string);
            this.errorFree = false;
            break;
          case WARNING:
            String _string_1 = issue.toString();
            this.logger.warn(_string_1);
            break;
          case INFO:
            String _string_2 = issue.toString();
            this.logger.info(_string_2);
            break;
          case IGNORE:
            String _string_3 = issue.toString();
            this.logger.debug(_string_3);
            break;
          default:
            break;
        }
      } else {
      }
    }
    return this.errorFree;
  }
  
  public GradleValidatonCallback(final Logger logger) {
    super();
    this.logger = logger;
  }
  
  @Pure
  public boolean isErrorFree() {
    return this.errorFree;
  }
  
  public void setErrorFree(final boolean errorFree) {
    this.errorFree = errorFree;
  }
}
