package org.xtext.gradle.builder;

import java.io.File;
import java.util.Collection;
import java.util.Map;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Pure;
import org.gradle.api.file.FileCollection;

@Accessors
@SuppressWarnings("all")
public class InstallDebugInfoRequest {
  @Accessors
  public static class SourceInstallerConfig {
    private boolean hideSyntheticVariables;
    
    private InstallDebugInfoRequest.SourceInstaller sourceInstaller;
    
    @Pure
    public boolean isHideSyntheticVariables() {
      return this.hideSyntheticVariables;
    }
    
    public void setHideSyntheticVariables(final boolean hideSyntheticVariables) {
      this.hideSyntheticVariables = hideSyntheticVariables;
    }
    
    @Pure
    public InstallDebugInfoRequest.SourceInstaller getSourceInstaller() {
      return this.sourceInstaller;
    }
    
    public void setSourceInstaller(final InstallDebugInfoRequest.SourceInstaller sourceInstaller) {
      this.sourceInstaller = sourceInstaller;
    }
  }
  
  public enum SourceInstaller {
    PRIMARY,
    
    SMAP,
    
    NONE;
  }
  
  private Collection<File> generatedJavaFiles = CollectionLiterals.<File>newArrayList();
  
  private FileCollection classesDirs;
  
  private Map<String, InstallDebugInfoRequest.SourceInstallerConfig> sourceInstallerByFileExtension = CollectionLiterals.<String, InstallDebugInfoRequest.SourceInstallerConfig>newHashMap();
  
  private ResourceSet resourceSet;
  
  @Pure
  public Collection<File> getGeneratedJavaFiles() {
    return this.generatedJavaFiles;
  }
  
  public void setGeneratedJavaFiles(final Collection<File> generatedJavaFiles) {
    this.generatedJavaFiles = generatedJavaFiles;
  }
  
  @Pure
  public FileCollection getClassesDirs() {
    return this.classesDirs;
  }
  
  public void setClassesDirs(final FileCollection classesDirs) {
    this.classesDirs = classesDirs;
  }
  
  @Pure
  public Map<String, InstallDebugInfoRequest.SourceInstallerConfig> getSourceInstallerByFileExtension() {
    return this.sourceInstallerByFileExtension;
  }
  
  public void setSourceInstallerByFileExtension(final Map<String, InstallDebugInfoRequest.SourceInstallerConfig> sourceInstallerByFileExtension) {
    this.sourceInstallerByFileExtension = sourceInstallerByFileExtension;
  }
  
  @Pure
  public ResourceSet getResourceSet() {
    return this.resourceSet;
  }
  
  public void setResourceSet(final ResourceSet resourceSet) {
    this.resourceSet = resourceSet;
  }
}
