package org.xtext.gradle.builder;

import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.hash.Funnels;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.common.io.ByteSource;
import com.google.common.io.Files;
import com.google.inject.Guice;
import com.google.inject.Injector;
import java.io.Closeable;
import java.io.File;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.ISetup;
import org.eclipse.xtext.build.BuildRequest;
import org.eclipse.xtext.build.IncrementalBuilder;
import org.eclipse.xtext.build.IndexState;
import org.eclipse.xtext.build.Source2GeneratedMapping;
import org.eclipse.xtext.generator.OutputConfiguration;
import org.eclipse.xtext.generator.OutputConfigurationAdapter;
import org.eclipse.xtext.mwe.PathTraverser;
import org.eclipse.xtext.parser.IEncodingProvider;
import org.eclipse.xtext.preferences.MapBasedPreferenceValues;
import org.eclipse.xtext.preferences.PreferenceValuesByLanguage;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.resource.impl.ChunkedResourceDescriptions;
import org.eclipse.xtext.resource.impl.ProjectDescription;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsData;
import org.eclipse.xtext.util.UriUtil;
import org.eclipse.xtext.util.internal.AlternateJdkLoader;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.workspace.ProjectConfigAdapter;
import org.eclipse.xtext.xbase.compiler.GeneratorConfig;
import org.eclipse.xtext.xbase.compiler.GeneratorConfigProvider;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.MapExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure2;
import org.gradle.api.GradleException;
import org.gradle.api.JavaVersion;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.Logger;
import org.xtext.gradle.builder.DebugInfoInstaller;
import org.xtext.gradle.builder.GradleProjectConfig;
import org.xtext.gradle.builder.GradleResourceDescriptions;
import org.xtext.gradle.builder.GradleValidatonCallback;
import org.xtext.gradle.builder.InstallDebugInfoRequest;
import org.xtext.gradle.protocol.GradleBuildRequest;
import org.xtext.gradle.protocol.GradleBuildResponse;
import org.xtext.gradle.protocol.GradleGeneratorConfig;
import org.xtext.gradle.protocol.GradleInstallDebugInfoRequest;
import org.xtext.gradle.protocol.GradleOutputConfig;
import org.xtext.gradle.protocol.IncrementalXtextBuilder;

@SuppressWarnings("all")
public class XtextGradleBuilder implements IncrementalXtextBuilder {
  private final GradleResourceDescriptions index = new GradleResourceDescriptions();
  
  private final ConcurrentHashMap<File, HashCode> dependencyHashes = new ConcurrentHashMap<File, HashCode>();
  
  private final ConcurrentHashMap<String, Source2GeneratedMapping> generatedMappings = new ConcurrentHashMap<String, Source2GeneratedMapping>();
  
  private final Injector sharedInjector = Guice.createInjector();
  
  private final IncrementalBuilder incrementalbuilder = this.sharedInjector.<IncrementalBuilder>getInstance(IncrementalBuilder.class);
  
  private final DebugInfoInstaller debugInfoInstaller = this.sharedInjector.<DebugInfoInstaller>getInstance(DebugInfoInstaller.class);
  
  public XtextGradleBuilder(final Set<String> setupNames, final String encoding) throws Exception {
    System.setProperty("org.eclipse.emf.common.util.ReferenceClearingQueue", "false");
    for (final String setupName : setupNames) {
      {
        Class<? extends XtextGradleBuilder> _class = this.getClass();
        ClassLoader _classLoader = _class.getClassLoader();
        final Class<?> setupClass = _classLoader.loadClass(setupName);
        Object _newInstance = setupClass.newInstance();
        final ISetup setup = ((ISetup) _newInstance);
        final Injector injector = setup.createInjectorAndDoEMFRegistration();
        IEncodingProvider.Runtime _instance = injector.<IEncodingProvider.Runtime>getInstance(IEncodingProvider.Runtime.class);
        _instance.setDefaultEncoding(encoding);
      }
    }
  }
  
  @Override
  public GradleBuildResponse build(final GradleBuildRequest gradleRequest) {
    final String containerHandle = gradleRequest.getContainerHandle();
    Logger _logger = gradleRequest.getLogger();
    final GradleValidatonCallback validator = new GradleValidatonCallback(_logger);
    final GradleBuildResponse response = new GradleBuildResponse();
    this.indexChangedClasspathEntries(gradleRequest);
    BuildRequest _buildRequest = new BuildRequest();
    final Procedure1<BuildRequest> _function = (BuildRequest it) -> {
      File _projectDir = gradleRequest.getProjectDir();
      URI _createFolderURI = UriUtil.createFolderURI(_projectDir);
      it.setBaseDir(_createFolderURI);
      boolean _needsCleanBuild = this.needsCleanBuild(gradleRequest);
      if (_needsCleanBuild) {
        Collection<File> _allFiles = gradleRequest.getAllFiles();
        final Function1<File, URI> _function_1 = (File it_1) -> {
          String _absolutePath = it_1.getAbsolutePath();
          return URI.createFileURI(_absolutePath);
        };
        Iterable<URI> _map = IterableExtensions.<File, URI>map(_allFiles, _function_1);
        List<URI> _list = IterableExtensions.<URI>toList(_map);
        it.setDirtyFiles(_list);
        IndexState _indexState = new IndexState();
        it.setState(_indexState);
      } else {
        Collection<File> _dirtyFiles = gradleRequest.getDirtyFiles();
        final Function1<File, URI> _function_2 = (File it_1) -> {
          String _absolutePath = it_1.getAbsolutePath();
          return URI.createFileURI(_absolutePath);
        };
        Iterable<URI> _map_1 = IterableExtensions.<File, URI>map(_dirtyFiles, _function_2);
        List<URI> _list_1 = IterableExtensions.<URI>toList(_map_1);
        it.setDirtyFiles(_list_1);
        Collection<File> _deletedFiles = gradleRequest.getDeletedFiles();
        final Function1<File, URI> _function_3 = (File it_1) -> {
          String _absolutePath = it_1.getAbsolutePath();
          return URI.createFileURI(_absolutePath);
        };
        Iterable<URI> _map_2 = IterableExtensions.<File, URI>map(_deletedFiles, _function_3);
        List<URI> _list_2 = IterableExtensions.<URI>toList(_map_2);
        it.setDeletedFiles(_list_2);
        ResourceDescriptionsData _elvis = null;
        ResourceDescriptionsData _container = this.index.getContainer(containerHandle);
        ResourceDescriptionsData _copy = null;
        if (_container!=null) {
          _copy=_container.copy();
        }
        if (_copy != null) {
          _elvis = _copy;
        } else {
          List<IResourceDescription> _emptyList = CollectionLiterals.<IResourceDescription>emptyList();
          ResourceDescriptionsData _resourceDescriptionsData = new ResourceDescriptionsData(_emptyList);
          _elvis = _resourceDescriptionsData;
        }
        final ResourceDescriptionsData indexChunk = _elvis;
        Source2GeneratedMapping _elvis_1 = null;
        Source2GeneratedMapping _get = this.generatedMappings.get(containerHandle);
        Source2GeneratedMapping _copy_1 = null;
        if (_get!=null) {
          _copy_1=_get.copy();
        }
        if (_copy_1 != null) {
          _elvis_1 = _copy_1;
        } else {
          Source2GeneratedMapping _source2GeneratedMapping = new Source2GeneratedMapping();
          _elvis_1 = _source2GeneratedMapping;
        }
        final Source2GeneratedMapping fileMappings = _elvis_1;
        IndexState _indexState_1 = new IndexState(indexChunk, fileMappings);
        it.setState(_indexState_1);
      }
      it.setAfterValidate(validator);
      final Procedure2<URI, URI> _function_4 = (URI source, URI target) -> {
        Collection<File> _generatedFiles = response.getGeneratedFiles();
        String _fileString = target.toFileString();
        File _file = new File(_fileString);
        _generatedFiles.add(_file);
      };
      it.setAfterGenerateFile(_function_4);
      IndexState _state = it.getState();
      ResourceDescriptionsData _resourceDescriptions = _state.getResourceDescriptions();
      this.preparResourceSet(it, containerHandle, _resourceDescriptions, gradleRequest);
    };
    final BuildRequest request = ObjectExtensions.<BuildRequest>operator_doubleArrow(_buildRequest, _function);
    final IncrementalBuilder.Result result = this.doBuild(request, gradleRequest);
    boolean _isErrorFree = validator.isErrorFree();
    boolean _not = (!_isErrorFree);
    if (_not) {
      throw new GradleException("Xtext validation failed, see build log for details.");
    }
    final IndexState resultingIndex = result.getIndexState();
    ResourceDescriptionsData _resourceDescriptions = resultingIndex.getResourceDescriptions();
    this.index.setContainer(containerHandle, _resourceDescriptions);
    Source2GeneratedMapping _fileMappings = resultingIndex.getFileMappings();
    this.generatedMappings.put(containerHandle, _fileMappings);
    return response;
  }
  
  private void indexChangedClasspathEntries(final GradleBuildRequest gradleRequest) {
    final IResourceServiceProvider.Registry registry = IResourceServiceProvider.Registry.INSTANCE;
    Collection<File> _dirtyClasspathEntries = gradleRequest.getDirtyClasspathEntries();
    final Function1<File, Boolean> _function = (File it) -> {
      return Boolean.valueOf(it.exists());
    };
    Iterable<File> _filter = IterableExtensions.<File>filter(_dirtyClasspathEntries, _function);
    final Consumer<File> _function_1 = (File dirtyClasspathEntry) -> {
      final HashCode hash = this.hash(dirtyClasspathEntry);
      HashCode _get = this.dependencyHashes.get(dirtyClasspathEntry);
      boolean _notEquals = (!Objects.equal(_get, hash));
      if (_notEquals) {
        final String containerHandle = dirtyClasspathEntry.getPath();
        BuildRequest _buildRequest = new BuildRequest();
        final Procedure1<BuildRequest> _function_2 = (BuildRequest it) -> {
          it.setIndexOnly(true);
          List<URI> _dirtyFiles = it.getDirtyFiles();
          PathTraverser _pathTraverser = new PathTraverser();
          String _path = dirtyClasspathEntry.getPath();
          final Predicate<URI> _function_3 = (URI uri) -> {
            IResourceServiceProvider _resourceServiceProvider = registry.getResourceServiceProvider(uri);
            return (_resourceServiceProvider != null);
          };
          Set<URI> _findAllResourceUris = _pathTraverser.findAllResourceUris(_path, _function_3);
          Iterables.<URI>addAll(_dirtyFiles, _findAllResourceUris);
          final BuildRequest.IPostValidationCallback _function_4 = (URI $0, Iterable<Issue> $1) -> {
            return false;
          };
          it.setAfterValidate(_function_4);
          List<IResourceDescription> _emptyList = CollectionLiterals.<IResourceDescription>emptyList();
          final ResourceDescriptionsData indexChunk = new ResourceDescriptionsData(_emptyList);
          final Source2GeneratedMapping fileMappings = new Source2GeneratedMapping();
          IndexState _indexState = new IndexState(indexChunk, fileMappings);
          it.setState(_indexState);
          this.preparResourceSet(it, containerHandle, indexChunk, gradleRequest);
        };
        final BuildRequest request = ObjectExtensions.<BuildRequest>operator_doubleArrow(_buildRequest, _function_2);
        final IncrementalBuilder.Result result = this.doBuild(request, gradleRequest);
        final IndexState resultingIndex = result.getIndexState();
        ResourceDescriptionsData _resourceDescriptions = resultingIndex.getResourceDescriptions();
        this.index.setContainer(containerHandle, _resourceDescriptions);
        this.dependencyHashes.put(dirtyClasspathEntry, hash);
      }
    };
    _filter.forEach(_function_1);
  }
  
  private HashCode hash(final File file) {
    HashCode _xblockexpression = null;
    {
      HashFunction _md5 = Hashing.md5();
      final Hasher hasher = _md5.newHasher();
      this.hash(file, hasher);
      _xblockexpression = hasher.hash();
    }
    return _xblockexpression;
  }
  
  private void hash(final File file, final Hasher hasher) {
    try {
      boolean _isDirectory = file.isDirectory();
      if (_isDirectory) {
        File[] _listFiles = file.listFiles();
        final Consumer<File> _function = (File it) -> {
          this.hash(it, hasher);
        };
        ((List<File>)Conversions.doWrapArray(_listFiles)).forEach(_function);
      } else {
        ByteSource _asByteSource = Files.asByteSource(file);
        OutputStream _asOutputStream = Funnels.asOutputStream(hasher);
        _asByteSource.copyTo(_asOutputStream);
      }
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  private void preparResourceSet(final BuildRequest it, final String containerHandle, final ResourceDescriptionsData indexChunk, final GradleBuildRequest gradleRequest) {
    XtextResourceSet _instance = this.sharedInjector.<XtextResourceSet>getInstance(XtextResourceSet.class);
    final Procedure1<XtextResourceSet> _function = (XtextResourceSet it_1) -> {
      URLClassLoader _jvmTypesLoader = this.getJvmTypesLoader(gradleRequest);
      it_1.setClasspathURIContext(_jvmTypesLoader);
      this.attachProjectConfig(it_1, gradleRequest);
      this.attachGeneratorConfig(it_1, gradleRequest);
      this.attachOutputConfig(it_1, gradleRequest);
      this.attachPreferences(it_1, gradleRequest);
      Collection<File> _allClasspathEntries = gradleRequest.getAllClasspathEntries();
      final Function1<File, String> _function_1 = (File it_2) -> {
        return it_2.getPath();
      };
      Iterable<String> _map = IterableExtensions.<File, String>map(_allClasspathEntries, _function_1);
      List<String> _list = IterableExtensions.<String>toList(_map);
      this.attachProjectDescription(containerHandle, _list, it_1);
      final ChunkedResourceDescriptions contextualIndex = this.index.createShallowCopyWith(it_1);
      contextualIndex.setContainer(containerHandle, indexChunk);
    };
    XtextResourceSet _doubleArrow = ObjectExtensions.<XtextResourceSet>operator_doubleArrow(_instance, _function);
    it.setResourceSet(_doubleArrow);
  }
  
  private IncrementalBuilder.Result doBuild(final BuildRequest request, final GradleBuildRequest gradleRequest) {
    IncrementalBuilder.Result _xtrycatchfinallyexpression = null;
    try {
      IncrementalBuilder.Result _xblockexpression = null;
      {
        final IResourceServiceProvider.Registry registry = IResourceServiceProvider.Registry.INSTANCE;
        boolean _needsCleanBuild = this.needsCleanBuild(gradleRequest);
        if (_needsCleanBuild) {
          this.doClean(gradleRequest);
        }
        final Function1<URI, IResourceServiceProvider> _function = (URI uri) -> {
          return registry.getResourceServiceProvider(uri);
        };
        _xblockexpression = this.incrementalbuilder.build(request, _function);
      }
      _xtrycatchfinallyexpression = _xblockexpression;
    } finally {
      this.cleanup(gradleRequest, request);
    }
    return _xtrycatchfinallyexpression;
  }
  
  private void doClean(final GradleBuildRequest request) {
    Map<String, GradleGeneratorConfig> _generatorConfigsByLanguage = request.getGeneratorConfigsByLanguage();
    Collection<GradleGeneratorConfig> _values = _generatorConfigsByLanguage.values();
    final Function1<GradleGeneratorConfig, Set<GradleOutputConfig>> _function = (GradleGeneratorConfig it) -> {
      return it.getOutputConfigs();
    };
    Iterable<Set<GradleOutputConfig>> _map = IterableExtensions.<GradleGeneratorConfig, Set<GradleOutputConfig>>map(_values, _function);
    Iterable<GradleOutputConfig> _flatten = Iterables.<GradleOutputConfig>concat(_map);
    final Function1<GradleOutputConfig, Boolean> _function_1 = (GradleOutputConfig it) -> {
      return Boolean.valueOf(it.isCleanAutomatically());
    };
    Iterable<GradleOutputConfig> _filter = IterableExtensions.<GradleOutputConfig>filter(_flatten, _function_1);
    final Function1<GradleOutputConfig, File> _function_2 = (GradleOutputConfig it) -> {
      return it.getTarget();
    };
    Iterable<File> _map_1 = IterableExtensions.<GradleOutputConfig, File>map(_filter, _function_2);
    final Consumer<File> _function_3 = (File it) -> {
      this.deleteRecursive(it);
    };
    _map_1.forEach(_function_3);
  }
  
  private void deleteRecursive(final File file) {
    boolean _isDirectory = file.isDirectory();
    if (_isDirectory) {
      File[] _listFiles = file.listFiles();
      final Consumer<File> _function = (File it) -> {
        this.deleteRecursive(it);
      };
      ((List<File>)Conversions.doWrapArray(_listFiles)).forEach(_function);
    }
    file.delete();
  }
  
  private boolean needsCleanBuild(final GradleBuildRequest request) {
    boolean _or = false;
    boolean _or_1 = false;
    boolean _isIncremental = request.isIncremental();
    boolean _not = (!_isIncremental);
    if (_not) {
      _or_1 = true;
    } else {
      Collection<File> _dirtyClasspathEntries = request.getDirtyClasspathEntries();
      boolean _isEmpty = _dirtyClasspathEntries.isEmpty();
      boolean _not_1 = (!_isEmpty);
      _or_1 = _not_1;
    }
    if (_or_1) {
      _or = true;
    } else {
      String _containerHandle = request.getContainerHandle();
      ResourceDescriptionsData _container = this.index.getContainer(_containerHandle);
      boolean _tripleEquals = (_container == null);
      _or = _tripleEquals;
    }
    return _or;
  }
  
  private URLClassLoader getJvmTypesLoader(final GradleBuildRequest gradleRequest) {
    URLClassLoader _xblockexpression = null;
    {
      ClassLoader _xifexpression = null;
      boolean _or = false;
      FileCollection _bootstrapClasspath = gradleRequest.getBootstrapClasspath();
      boolean _tripleEquals = (_bootstrapClasspath == null);
      if (_tripleEquals) {
        _or = true;
      } else {
        FileCollection _bootstrapClasspath_1 = gradleRequest.getBootstrapClasspath();
        boolean _isEmpty = _bootstrapClasspath_1.isEmpty();
        _or = _isEmpty;
      }
      if (_or) {
        _xifexpression = ClassLoader.getSystemClassLoader();
      } else {
        FileCollection _bootstrapClasspath_2 = gradleRequest.getBootstrapClasspath();
        _xifexpression = new AlternateJdkLoader(_bootstrapClasspath_2);
      }
      final ClassLoader parent = _xifexpression;
      Collection<File> _allClasspathEntries = gradleRequest.getAllClasspathEntries();
      final Function1<File, URL> _function = (File it) -> {
        try {
          java.net.URI _uRI = it.toURI();
          return _uRI.toURL();
        } catch (Throwable _e) {
          throw Exceptions.sneakyThrow(_e);
        }
      };
      Iterable<URL> _map = IterableExtensions.<File, URL>map(_allClasspathEntries, _function);
      _xblockexpression = new URLClassLoader(((URL[])Conversions.unwrapArray(_map, URL.class)), parent);
    }
    return _xblockexpression;
  }
  
  private void cleanup(final GradleBuildRequest gradleRequest, final BuildRequest request) {
    final XtextResourceSet resourceSet = request.getResourceSet();
    final Object jvmTypesLoader = resourceSet.getClasspathURIContext();
    if ((jvmTypesLoader instanceof Closeable)) {
      try {
        ((Closeable)jvmTypesLoader).close();
      } catch (final Throwable _t) {
        if (_t instanceof Exception) {
          final Exception e = (Exception)_t;
          Logger _logger = gradleRequest.getLogger();
          _logger.debug("Couldn\'t close jvm types classloader", e);
        } else {
          throw Exceptions.sneakyThrow(_t);
        }
      }
    }
    EList<Resource> _resources = resourceSet.getResources();
    _resources.clear();
    EList<Adapter> _eAdapters = resourceSet.eAdapters();
    _eAdapters.clear();
  }
  
  private void attachProjectConfig(final XtextResourceSet resourceSet, final GradleBuildRequest gradleRequest) {
    GradleProjectConfig _gradleProjectConfig = new GradleProjectConfig(gradleRequest);
    ProjectConfigAdapter.install(resourceSet, _gradleProjectConfig);
  }
  
  private ProjectDescription attachProjectDescription(final String containerHandle, final List<String> dependencies, final XtextResourceSet resourceSet) {
    ProjectDescription _projectDescription = new ProjectDescription();
    final Procedure1<ProjectDescription> _function = (ProjectDescription it) -> {
      it.setName(containerHandle);
      it.setDependencies(dependencies);
      it.attachToEmfObject(resourceSet);
    };
    return ObjectExtensions.<ProjectDescription>operator_doubleArrow(_projectDescription, _function);
  }
  
  private GeneratorConfigProvider.GeneratorConfigAdapter attachGeneratorConfig(final XtextResourceSet resourceSet, final GradleBuildRequest gradleRequest) {
    GeneratorConfigProvider.GeneratorConfigAdapter _generatorConfigAdapter = new GeneratorConfigProvider.GeneratorConfigAdapter();
    final Procedure1<GeneratorConfigProvider.GeneratorConfigAdapter> _function = (GeneratorConfigProvider.GeneratorConfigAdapter it) -> {
      it.attachToEmfObject(resourceSet);
      Map<String, GeneratorConfig> _language2GeneratorConfig = it.getLanguage2GeneratorConfig();
      Map<String, GradleGeneratorConfig> _generatorConfigsByLanguage = gradleRequest.getGeneratorConfigsByLanguage();
      final Function1<GradleGeneratorConfig, GeneratorConfig> _function_1 = (GradleGeneratorConfig gradleConfig) -> {
        GeneratorConfig _generatorConfig = new GeneratorConfig();
        final Procedure1<GeneratorConfig> _function_2 = (GeneratorConfig it_1) -> {
          boolean _isGenerateSyntheticSuppressWarnings = gradleConfig.isGenerateSyntheticSuppressWarnings();
          it_1.setGenerateSyntheticSuppressWarnings(_isGenerateSyntheticSuppressWarnings);
          boolean _isGenerateGeneratedAnnotation = gradleConfig.isGenerateGeneratedAnnotation();
          it_1.setGenerateGeneratedAnnotation(_isGenerateGeneratedAnnotation);
          boolean _isIncludeDateInGeneratedAnnotation = gradleConfig.isIncludeDateInGeneratedAnnotation();
          it_1.setIncludeDateInGeneratedAnnotation(_isIncludeDateInGeneratedAnnotation);
          String _generatedAnnotationComment = gradleConfig.getGeneratedAnnotationComment();
          it_1.setGeneratedAnnotationComment(_generatedAnnotationComment);
          JavaVersion _javaSourceLevel = gradleConfig.getJavaSourceLevel();
          String _string = _javaSourceLevel.toString();
          org.eclipse.xtext.util.JavaVersion _fromQualifier = org.eclipse.xtext.util.JavaVersion.fromQualifier(_string);
          it_1.setJavaSourceVersion(_fromQualifier);
        };
        return ObjectExtensions.<GeneratorConfig>operator_doubleArrow(_generatorConfig, _function_2);
      };
      Map<String, GeneratorConfig> _mapValues = MapExtensions.<String, GradleGeneratorConfig, GeneratorConfig>mapValues(_generatorConfigsByLanguage, _function_1);
      _language2GeneratorConfig.putAll(_mapValues);
    };
    return ObjectExtensions.<GeneratorConfigProvider.GeneratorConfigAdapter>operator_doubleArrow(_generatorConfigAdapter, _function);
  }
  
  private boolean attachOutputConfig(final XtextResourceSet resourceSet, final GradleBuildRequest gradleRequest) {
    EList<Adapter> _eAdapters = resourceSet.eAdapters();
    Map<String, GradleGeneratorConfig> _generatorConfigsByLanguage = gradleRequest.getGeneratorConfigsByLanguage();
    final Function1<GradleGeneratorConfig, Set<OutputConfiguration>> _function = (GradleGeneratorConfig it) -> {
      Set<GradleOutputConfig> _outputConfigs = it.getOutputConfigs();
      final Function1<GradleOutputConfig, OutputConfiguration> _function_1 = (GradleOutputConfig gradleOutputConfig) -> {
        String _outletName = gradleOutputConfig.getOutletName();
        OutputConfiguration _outputConfiguration = new OutputConfiguration(_outletName);
        final Procedure1<OutputConfiguration> _function_2 = (OutputConfiguration it_1) -> {
          File _target = gradleOutputConfig.getTarget();
          String _absolutePath = _target.getAbsolutePath();
          it_1.setOutputDirectory(_absolutePath);
        };
        return ObjectExtensions.<OutputConfiguration>operator_doubleArrow(_outputConfiguration, _function_2);
      };
      Iterable<OutputConfiguration> _map = IterableExtensions.<GradleOutputConfig, OutputConfiguration>map(_outputConfigs, _function_1);
      return IterableExtensions.<OutputConfiguration>toSet(_map);
    };
    Map<String, Set<OutputConfiguration>> _mapValues = MapExtensions.<String, GradleGeneratorConfig, Set<OutputConfiguration>>mapValues(_generatorConfigsByLanguage, _function);
    OutputConfigurationAdapter _outputConfigurationAdapter = new OutputConfigurationAdapter(_mapValues);
    return _eAdapters.add(_outputConfigurationAdapter);
  }
  
  private PreferenceValuesByLanguage attachPreferences(final XtextResourceSet resourceSet, final GradleBuildRequest gradleRequest) {
    PreferenceValuesByLanguage _preferenceValuesByLanguage = new PreferenceValuesByLanguage();
    final Procedure1<PreferenceValuesByLanguage> _function = (PreferenceValuesByLanguage it) -> {
      it.attachToEmfObject(resourceSet);
      Map<String, Map<String, String>> _preferencesByLanguage = gradleRequest.getPreferencesByLanguage();
      Set<Map.Entry<String, Map<String, String>>> _entrySet = _preferencesByLanguage.entrySet();
      for (final Map.Entry<String, Map<String, String>> entry : _entrySet) {
        String _key = entry.getKey();
        Map<String, String> _value = entry.getValue();
        MapBasedPreferenceValues _mapBasedPreferenceValues = new MapBasedPreferenceValues(_value);
        it.put(_key, _mapBasedPreferenceValues);
      }
    };
    return ObjectExtensions.<PreferenceValuesByLanguage>operator_doubleArrow(_preferenceValuesByLanguage, _function);
  }
  
  @Override
  public void installDebugInfo(final GradleInstallDebugInfoRequest gradleRequest) {
    InstallDebugInfoRequest _installDebugInfoRequest = new InstallDebugInfoRequest();
    final Procedure1<InstallDebugInfoRequest> _function = (InstallDebugInfoRequest it) -> {
      FileCollection _classesDirs = gradleRequest.getClassesDirs();
      it.setClassesDirs(_classesDirs);
      Map<String, GradleInstallDebugInfoRequest.GradleSourceInstallerConfig> _sourceInstallerByFileExtension = gradleRequest.getSourceInstallerByFileExtension();
      final Function1<GradleInstallDebugInfoRequest.GradleSourceInstallerConfig, InstallDebugInfoRequest.SourceInstallerConfig> _function_1 = (GradleInstallDebugInfoRequest.GradleSourceInstallerConfig gradleConfig) -> {
        InstallDebugInfoRequest.SourceInstallerConfig _sourceInstallerConfig = new InstallDebugInfoRequest.SourceInstallerConfig();
        final Procedure1<InstallDebugInfoRequest.SourceInstallerConfig> _function_2 = (InstallDebugInfoRequest.SourceInstallerConfig it_1) -> {
          GradleInstallDebugInfoRequest.SourceInstaller _sourceInstaller = gradleConfig.getSourceInstaller();
          String _name = _sourceInstaller.name();
          InstallDebugInfoRequest.SourceInstaller _valueOf = InstallDebugInfoRequest.SourceInstaller.valueOf(_name);
          it_1.setSourceInstaller(_valueOf);
          boolean _isHideSyntheticVariables = gradleConfig.isHideSyntheticVariables();
          it_1.setHideSyntheticVariables(_isHideSyntheticVariables);
        };
        return ObjectExtensions.<InstallDebugInfoRequest.SourceInstallerConfig>operator_doubleArrow(_sourceInstallerConfig, _function_2);
      };
      Map<String, InstallDebugInfoRequest.SourceInstallerConfig> _mapValues = MapExtensions.<String, GradleInstallDebugInfoRequest.GradleSourceInstallerConfig, InstallDebugInfoRequest.SourceInstallerConfig>mapValues(_sourceInstallerByFileExtension, _function_1);
      it.setSourceInstallerByFileExtension(_mapValues);
      Collection<File> _generatedJavaFiles = gradleRequest.getGeneratedJavaFiles();
      it.setGeneratedJavaFiles(_generatedJavaFiles);
      XtextResourceSet _instance = this.sharedInjector.<XtextResourceSet>getInstance(XtextResourceSet.class);
      final Procedure1<XtextResourceSet> _function_2 = (XtextResourceSet it_1) -> {
        ClassLoader _systemClassLoader = ClassLoader.getSystemClassLoader();
        it_1.setClasspathURIContext(_systemClassLoader);
        Map<String, ResourceDescriptionsData> _emptyMap = CollectionLiterals.<String, ResourceDescriptionsData>emptyMap();
        new ChunkedResourceDescriptions(_emptyMap, it_1);
      };
      XtextResourceSet _doubleArrow = ObjectExtensions.<XtextResourceSet>operator_doubleArrow(_instance, _function_2);
      it.setResourceSet(_doubleArrow);
    };
    final InstallDebugInfoRequest request = ObjectExtensions.<InstallDebugInfoRequest>operator_doubleArrow(_installDebugInfoRequest, _function);
    this.debugInfoInstaller.installDebugInfo(request);
  }
}
