package org.xyou.xcommon.app;

import lombok.AccessLevel;
import lombok.Getter;

final class Model {

    @Getter(AccessLevel.PACKAGE)
    private String name;
    @Getter(AccessLevel.PACKAGE)
    private String prof;
    @Getter(AccessLevel.PACKAGE)
    private String zconfdir;
    @Getter(AccessLevel.PACKAGE)
    private String zconffiles;

    private static class Holder {

        public static final Model INST = new Model();
    }

    static Model getInst() {
        return Holder.INST;
    }

    private Model() {
        name = getKwArg("zappname");
        prof = getKwArg("zappprof");
        zconfdir = getKwArg("zconfdir");
        zconffiles = getKwArg("zconffiles");
    }

    private static String getKwArg(String key) {
        try {
            return System.getProperty(key);
        } catch (Throwable ex) {
        }
        return null;
    }

}
