package org.xyou.xcommon.base;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.xyou.xcommon.map.XMap;
import org.xyou.xcommon.tool.XStr;

import lombok.AccessLevel;
import lombok.Getter;

@Getter(AccessLevel.PUBLIC)
public abstract class XBaseType extends XBaseObject {

    private static final long serialVersionUID = 1L;

    private final String nameDefault;
    private transient List<Integer> lsId;
    private transient List<String> lsName;
    private transient Set<Integer> setId;
    private transient Set<String> setName;
    private transient Map<Integer, String> mapIdName;
    private transient Map<String, Integer> mapNameId;

    protected XBaseType() {
        this(null);
    }

    protected XBaseType(String nameDefault) {
        this.nameDefault = nameDefault;
        mapIdName = new HashMap<>();
        lsId = new ArrayList<>();
        for (Field field : this.getClass().getDeclaredFields()) {
            try {
                if (field.isSynthetic()) {
                    continue;
                }
                int typeModifier = field.getModifiers();
                if (!Modifier.isStatic(typeModifier)) {
                    continue;
                }
                if (!Modifier.isPublic(typeModifier)) {
                    continue;
                }
                field.setAccessible(true);
                String name = field.getName();
                name = name.toUpperCase();
                Integer id = field.getInt(null);
                mapIdName.put(id, name);
                lsId.add(id);
            } catch (Throwable ex) {
            }
        }
        lsName = XMap.getLsValueByLsKey(mapIdName, lsId);
        setId = new HashSet<>(lsId);
        setName = new HashSet<>(lsName);
        mapNameId = XMap.reverse(mapIdName);
        lsId = Collections.unmodifiableList(lsId);
        lsName = Collections.unmodifiableList(lsName);
        setId = Collections.unmodifiableSet(setId);
        setName = Collections.unmodifiableSet(setName);
        mapIdName = Collections.unmodifiableMap(mapIdName);
        mapNameId = Collections.unmodifiableMap(mapNameId);
    }

    public Integer getId(String name) {
        if (XStr.isEmpty(name)) {
            return null;
        }

        String nameUpperCase = name.toUpperCase();
        return mapNameId.get(nameUpperCase);
    }

    public String getName(int id) {
        return mapIdName.getOrDefault(id, nameDefault);
    }

}
