package org.xyou.xcommon.codec;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import org.xyou.xcommon.map.XMap;
import org.xyou.xcommon.tool.XStr;

public final class XCodec {

    public static boolean isValidId(Object id) {
        if (id instanceof String) {
            return true;
        }
        if (id instanceof Number) {
            Long idLong = ((Number) id).longValue();
            if (idLong < 1l) {
                return false;
            }
            return true;
        }
        return false;
    }

    public static List<String> encodeIdInt(List<Integer> lsId, int salt) {
        Map<Integer, String> cache = new HashMap<>();
        return encodeIdInt(lsId, salt, cache);
    }

    public static List<String> encodeIdLong(List<Long> lsId, int salt) {
        Map<Long, String> cache = new HashMap<>();
        return encodeIdLong(lsId, salt, cache);
    }

    public static List<Integer> decodeIdInt(List<String> lsId, int salt) {
        Map<String, Integer> cache = new HashMap<>();
        return decodeIdInt(lsId, salt, cache);
    }

    public static List<Long> decodeIdLong(List<String> lsId, int salt) {
        Map<String, Long> cache = new HashMap<>();
        return decodeIdLong(lsId, salt, cache);
    }

    public static List<String> encodeIdInt(List<Integer> lsId, int salt, Map<Integer, String> cache) {
        try {
            return lsId.stream()
                .map(id -> encodeIdInt(id, salt, cache))
                .filter(ele -> ele != null)
                .collect(Collectors.toList());
        } catch (Throwable ex) {
        }
        return null;
    }

    public static List<String> encodeIdLong(List<Long> lsId, int salt, Map<Long, String> cache) {
        try {
            return lsId.stream()
                .map(id -> encodeIdLong(id, salt, cache))
                .filter(ele -> ele != null)
                .collect(Collectors.toList());
        } catch (Throwable ex) {
        }
        return null;
    }

    public static List<Integer> decodeIdInt(List<String> lsId, int salt, Map<String, Integer> cache) {
        try {
            return lsId.stream()
                .map(id -> decodeIdInt(id, salt, cache))
                .filter(ele -> ele != null)
                .collect(Collectors.toList());
        } catch (Throwable ex) {
        }
        return null;

    }

    public static List<Long> decodeIdLong(List<String> lsId, int salt, Map<String, Long> cache) {
        try {
            return lsId.stream()
                .map(id -> decodeIdLong(id, salt, cache))
                .filter(ele -> ele != null)
                .collect(Collectors.toList());
        } catch (Throwable ex) {
        }
        return null;
    }

    public static String encodeIdLong(Long id, int salt, Map<Long, String> cache) {
        if (!isValidId(id)) {
            return null;
        }
        String idEncoded = null;
        if (!XMap.isEmpty(cache)) {
            idEncoded = cache.get(id);
        }
        if (idEncoded != null) {
            return idEncoded;
        }
        idEncoded = encodeIdLong(id, salt);
        cache.put(id, idEncoded);
        return idEncoded;
    }

    public static String encodeIdInt(Integer id, int salt, Map<Integer, String> cache) {
        if (!isValidId(id)) {
            return null;
        }
        String idEncoded = null;
        if (!XMap.isEmpty(cache)) {
            idEncoded = cache.get(id);
        }
        if (idEncoded != null) {
            return idEncoded;
        }
        idEncoded = encodeIdInt(id, salt);
        cache.put(id, idEncoded);
        return idEncoded;
    }

    public static Long decodeIdLong(String idEncoded, int offset, Map<String, Long> cache) {
        if (XStr.isEmpty(idEncoded)) {
            return null;
        }
        Long idDecoded = null;
        if (!XMap.isEmpty(cache)) {
            idDecoded = cache.get(idEncoded);
        }
        if (idDecoded != null) {
            return idDecoded;
        }
        idDecoded = decodeIdLong(idEncoded, offset);
        cache.put(idEncoded, idDecoded);
        return idDecoded;
    }

    public static Integer decodeIdInt(String idEncoded, int salr, Map<String, Integer> cache) {
        if (XStr.isEmpty(idEncoded)) {
            return null;
        }
        Integer idDecoded = null;
        if (!XMap.isEmpty(cache)) {
            idDecoded = cache.get(idEncoded);
        }
        if (idDecoded != null) {
            return idDecoded;
        }
        idDecoded = decodeIdInt(idEncoded, salr);
        cache.put(idEncoded, idDecoded);
        return idDecoded;
    }

    public static String encodeIdLong(Long id, int salt) {
        if (!isValidId(id)) {
            return null;
        }
        byte[] arrByte = ByteBuffer.allocate(Long.BYTES).putLong(id ^ salt).array();
        return encodeIdByte(arrByte);
    }

    public static String encodeIdInt(Integer id, int salt) {
        if (!isValidId(id)) {
            return null;
        }
        byte[] arrByte = ByteBuffer.allocate(Integer.BYTES).putInt(id ^ salt).array();
        return encodeIdByte(arrByte);
    }

    public static String encodeIdByte(byte[] id) {
        String encoded = XStr.encodeBase64(id);
        encoded = Model.getInst().encode(encoded);
        String encodedNoPad = encoded.substring(0, encoded.length() - 2);
        return Model.getInst().getPrefix() + encodedNoPad;
    }

    public static Long decodeIdLong(String idEncoded, int salt) {
        if (XStr.isEmpty(idEncoded)) {
            return null;
        }
        String idEncodedPad = idEncoded + "==";
        String decoded = Model.getInst().decode(idEncodedPad.substring(Model.getInst().getPrefix().length()));
        byte[] arrByte = XStr.decodeBase64(decoded);
        return ByteBuffer.wrap(arrByte).getLong() ^ salt;
    }

    public static Integer decodeIdInt(String idEncoded, int salt) {
        if (XStr.isEmpty(idEncoded)) {
            return null;
        }
        String idEncodedPad = idEncoded + "==";
        String decoded = Model.getInst().decode(idEncodedPad.substring(Model.getInst().getPrefix().length()));
        byte[] arrByte = XStr.decodeBase64(decoded);
        return ByteBuffer.wrap(arrByte).getInt() ^ salt;
    }

}
