package org.xyou.xcommon.config;

import java.util.Collections;
import java.util.List;

import org.ini4j.Wini;
import org.xyou.xcommon.entity.XObj;
import org.xyou.xcommon.logger.XLogger;
import org.xyou.xcommon.tool.XFile;
import org.xyou.xcommon.yaml.XYaml;

import lombok.AccessLevel;
import lombok.Getter;

final class Model {

    private final transient XLogger logger;
    @Getter(AccessLevel.PACKAGE)
    private final transient XObj mapSection;

    private static class Holder {

        public static final Model INST = new Model();
    }

    static Model getInst() {
        return Holder.INST;
    }

    private Model() {
        logger = new XLogger();
        mapSection = new XObj();
        try {
            Collections.list(ClassLoader.getSystemResources("conf/production.config.ini")).forEach(urlConfig -> {
                try {
                    logger.info("Read ini " + urlConfig.getPath());
                    new Wini(urlConfig).entrySet().forEach(entrySection -> {
                        XObj section = new XObj();
                        entrySection.getValue().entrySet().forEach(entry -> {
                            section.put(entry.getKey(), entry.getValue());
                        });
                        put(entrySection.getKey(), section);
                    });
                } catch (Throwable ex) {
                    logger.error(ex);
                }
            });
            Collections.list(ClassLoader.getSystemResources("xconfig")).forEach(urlConfig -> {
                try {
                    String pathDir = urlConfig.getPath();
                    logger.info("At " + pathDir);
                    List<String> lsName = XFile.ls(pathDir);
                    for (String name : lsName) {
                        String pathFile = pathDir + "/" + name;
                        logger.info("Read " + pathFile);
                        XObj obj = XYaml.fromFile(pathFile, XObj.class);
                        obj.getMap().entrySet().forEach(entrySection -> {
                            put(entrySection.getKey(), entrySection.getValue());
                        });
                    }
                } catch (Throwable ex) {
                    logger.error(ex);
                }
            });

        } catch (Throwable ex) {
            logger.error(ex);
        }
    }

    private void put(Object key, Object section) {
        if (mapSection.containsKey(key)) {
            logger.info("Overwrite section " + key);
        } else {
            logger.info("Read section " + key);
        }
        mapSection.put(key, section);
    }

}
