package org.xyou.xcommon.config;

import java.util.Collections;
import java.util.List;
import java.util.Set;

import org.xyou.xcommon.base.XBaseObject;
import org.xyou.xcommon.entity.XObj;
import org.xyou.xcommon.tool.XCls;
import org.xyou.xcommon.tool.XCvt;

import lombok.AccessLevel;
import lombok.Getter;

public final class XConfig extends XBaseObject {

    private static final long serialVersionUID = 1L;

    @Getter(AccessLevel.PUBLIC)
    private final Class<?> cls;
    @Getter(AccessLevel.PUBLIC)
    private final String name;
    @Getter(AccessLevel.PUBLIC)
    private final String keyConf;

    private final transient XObj section;
    private final transient String prefixMsg;

    public XConfig(String name) {
        this.name = name;
        StackTraceElement eleStackTrace = new Exception().getStackTrace()[1];
        cls = XCls.getClassByNameClass(eleStackTrace.getClassName());
        String nameClass = cls.getSimpleName();
        keyConf = nameClass + "@" + name;
        Object data = Model.getInst().getMapSection().get(keyConf);
        prefixMsg = String.format("Config '%s'", keyConf);
        if (data == null) {
            throw new RuntimeException(prefixMsg + " missing");
        }
        section = new XObj().putAll(data);
    }

    public <V> V check(String key, V value) {
        String prefixMsgKey = String.format(prefixMsg + " key '%s'", key);
        if (!section.containsKey(key)) {
            throw new RuntimeException(prefixMsgKey + " missing");
        }
        if (value == null) {
            throw new RuntimeException(prefixMsgKey + " value invalid");
        }
        return value;
    }

    public String getStr(String key) {
        return check(key, getStr(key, null));
    }

    public String getStr(String key, String def) {
        return section.getStr(key, def);
    }

    public Integer getInt(String key) {
        return check(key, getInt(key, null));
    }

    public Integer getInt(String key, Integer def) {
        return XCvt.toInt(getStr(key, null), def);
    }

    public Long getLong(String key) {
        return check(key, getLong(key, null));
    }

    public Long getLong(String key, Long def) {
        return XCvt.toLong(getStr(key, null), def);
    }

    public Float getFloat(String key) {
        return check(key, getFloat(key, null));
    }

    public Float getFloat(String key, Float def) {
        return XCvt.toFloat(getStr(key, null), def);
    }

    public Double getDouble(String key) {
        return check(key, getDouble(key, null));
    }

    public Double getDouble(String key, Double def) {
        return XCvt.toDouble(getStr(key, null), def);
    }

    public Boolean getBool(String key) {
        return check(key, getBool(key, null));
    }

    public Boolean getBool(String key, Boolean def) {
        return XCvt.toBool(getStr(key, null), def);
    }

    public List<String> getLsStr(String key) {
        return check(key, getLsStr(key, null));
    }

    public List<String> getLsStr(String key, List<String> def) {
        return XCvt.toLsStr(getStr(key, null), def);
    }

    public List<Integer> getLsInt(String key) {
        return check(key, getLsInt(key, null));
    }

    public List<Integer> getLsInt(String key, List<Integer> def) {
        try {
            return Collections.unmodifiableList(XCvt.toLsInt(getStr(key)));
        } catch (Throwable ex) {
        }
        return def;
    }

    public List<Long> getLsLong(String key) {
        return check(key, getLsLong(key, null));
    }

    public List<Long> getLsLong(String key, List<Long> def) {
        try {
            return Collections.unmodifiableList(XCvt.toLsLong(getStr(key)));
        } catch (Throwable ex) {
        }
        return def;
    }

    public List<Float> getLsFloat(String key) {
        return check(key, getLsFloat(key, null));
    }

    public List<Float> getLsFloat(String key, List<Float> def) {
        try {
            return Collections.unmodifiableList(XCvt.toLsFloat(getStr(key)));
        } catch (Throwable ex) {
        }
        return def;
    }

    public List<Double> getLsDouble(String key) {
        return check(key, getLsDouble(key, null));
    }

    public List<Double> getLsDouble(String key, List<Double> def) {
        try {
            return Collections.unmodifiableList(XCvt.toLsDouble(getStr(key)));
        } catch (Throwable ex) {
        }
        return def;
    }

    public List<Boolean> getLsBool(String key) {
        return check(key, getLsBool(key, null));
    }

    public List<Boolean> getLsBool(String key, List<Boolean> def) {
        try {
            return Collections.unmodifiableList(XCvt.toLsBool(getStr(key)));
        } catch (Throwable ex) {
        }
        return def;
    }

    public Set<String> getSetStr(String key) {
        return check(key, getSetStr(key, null));
    }

    public Set<String> getSetStr(String key, Set<String> def) {
        try {
            return Collections.unmodifiableSet(XCvt.toSetStr(getStr(key)));
        } catch (Throwable ex) {
        }
        return def;
    }

    public Set<Integer> getSetInt(String key) {
        return check(key, getSetInt(key, null));
    }

    public Set<Integer> getSetInt(String key, Set<Integer> def) {
        try {
            return Collections.unmodifiableSet(XCvt.toSetInt(getStr(key)));
        } catch (Throwable ex) {
        }
        return def;
    }

    public Set<Long> getSetLong(String key) {
        return check(key, getSetLong(key, null));
    }

    public Set<Long> getSetLong(String key, Set<Long> def) {
        try {
            return Collections.unmodifiableSet(XCvt.toSetLong(getStr(key)));
        } catch (Throwable ex) {
        }
        return def;
    }

    public Set<Float> getSetFloat(String key) {
        return check(key, getSetFloat(key, null));
    }

    public Set<Float> getSetFloat(String key, Set<Float> def) {
        try {
            return Collections.unmodifiableSet(XCvt.toSetFloat(getStr(key)));
        } catch (Throwable ex) {
        }
        return def;
    }

    public Set<Double> getSetDouble(String key) {
        return check(key, getSetDouble(key, null));
    }

    public Set<Double> getSetDouble(String key, Set<Double> def) {
        try {
            return Collections.unmodifiableSet(XCvt.toSetDouble(getStr(key)));
        } catch (Throwable ex) {
        }
        return def;
    }

    public Set<Boolean> getSetBool(String key) {
        return check(key, getSetBool(key, null));
    }

    public Set<Boolean> getSetBool(String key, Set<Boolean> def) {
        try {
            return Collections.unmodifiableSet(XCvt.toSetBool(getStr(key)));
        } catch (Throwable ex) {
        }
        return def;
    }

}
