package org.xyou.xcommon.entity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import org.xyou.xcommon.base.XBaseObject;
import org.xyou.xcommon.seq.XSeq;

import lombok.AccessLevel;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

@Getter(AccessLevel.PUBLIC)
@Setter(AccessLevel.PUBLIC)
@EqualsAndHashCode(callSuper = true)
public final class XLs<V> extends XBaseObject {

    private static final long serialVersionUID = 1L;

    public static final XLs<?> EMPTY = new XLs<>();

    private Integer total;
    private List<V> lsData;

    public XLs() {
        this(new ArrayList<>());
    }

    public XLs(XLs<V> xLs, int idxStart, int count) {
        this(xLs.getLsData(), idxStart, count);
    }

    public XLs(List<V> lsData, int idxStart, int count) {
        this.lsData = Collections.unmodifiableList(
            XSeq.subLs(lsData, idxStart, count)
        );
        total = lsData.size();
    }

    public XLs(V data) {
        this(XSeq.newArrayList(data));
    }

    public XLs(List<V> lsData) {
        this(lsData, 0, lsData.size());
    }
}
