package org.xyou.xcommon.entity;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.xyou.xcommon.base.XBaseObject;
import org.xyou.xcommon.ex.XEx;
import org.xyou.xcommon.map.XMap;
import org.xyou.xcommon.tool.XCvt;
import org.xyou.xcommon.yaml.XJson;

import lombok.AccessLevel;
import lombok.EqualsAndHashCode;
import lombok.Getter;

@Getter(AccessLevel.PUBLIC)
@EqualsAndHashCode(callSuper = true)
public final class XObj extends XBaseObject {

    private static final long serialVersionUID = 1L;

    private final Map<Object, Object> map;

    public XObj() {
        map = new LinkedHashMap<>();
    }

    public static XObj fromObject(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            return XJson.fromStr((String) obj, XObj.class);
        }
        if (obj instanceof XObj || obj instanceof Map) {
            return new XObj().putAll(obj);
        }
        return fromObject(XJson.toStr(obj));
    }

    public static boolean isEmpty(XObj obj) {
        if (obj == null) {
            return true;
        }
        if (XMap.isEmpty(obj.getMap())) {
            return true;
        }
        return false;
    }

    public Set<Object> keySet() {
        return map.keySet();
    }

    public Collection<Object> values() {
        return map.values();
    }

    public boolean containsKey(Object key) {
        return map.containsKey(key);
    }

    public XObj put(Object key, Object value) {
        map.put(key, value);
        return this;
    }

    public XObj putAll(Object obj) {
        if (obj instanceof XObj) {
            return putAll(((XObj) obj).getMap());
        }
        if (obj instanceof Map) {
            @SuppressWarnings("unchecked")
            Map<Object, Object> mapCast = (Map<Object, Object>) obj;
            map.putAll(mapCast);
            return this;
        }
        throw XEx.createClassInvalid(obj);
    }

    public <V> XObj filterByLsKey(List<Object> lsKey) {
        XObj obj = new XObj();
        for (Object key : lsKey) {
            if (!this.containsKey(key)) {
                continue;
            }
            V value = get(key);
            obj.put(key, value);
        }
        return obj;
    }

    public <V> V get(Object key) {
        return get(key, null);
    }

    public <V> V get(Object key, V def) {
        try {
            @SuppressWarnings("unchecked")
            V value = (V) map.getOrDefault(key, def);
            return value;
        } catch (Throwable ex) {
        }
        return def;
    }

    public XObj getObj(Object key) {
        return getObj(key, null);
    }

    public XObj getObj(Object key, XObj def) {
        try {
            Object value = get(key);
            if (value == null) {
                return def;
            }
            return new XObj().putAll(value);
        } catch (Throwable ex) {
        }
        return def;
    }

    public String getStr(Object key) {
        return getStr(key, null);
    }

    public String getStr(Object key, String def) {
        return XCvt.toStr(get(key), def);
    }

    public Integer getInt(Object key) {
        return getInt(key, null);
    }

    public Integer getInt(Object key, Integer def) {
        return XCvt.toInt(get(key), def);
    }

    public Long getLong(Object key) {
        return getLong(key, null);
    }

    public Long getLong(Object key, Long def) {
        return XCvt.toLong(get(key), def);
    }

    public Float getFloat(Object key) {
        return getFloat(key, null);
    }

    public Float getFloat(Object key, Float def) {
        return XCvt.toFloat(get(key), def);
    }

    public Double getDouble(Object key) {
        return getDouble(key, null);
    }

    public Double getDouble(Object key, Double def) {
        return XCvt.toDouble(get(key), def);
    }

    public Boolean getBool(Object key) {
        return getBool(key, null);
    }

    public Boolean getBool(Object key, Boolean def) {
        return XCvt.toBool(get(key), def);
    }

    public Timestamp getTimestamp(Object key) {
        return getTimestamp(key, null);
    }

    public Timestamp getTimestamp(Object key, Timestamp def) {
        return XCvt.toTimestamp(get(key), def);
    }

    public List<XObj> getLsObj(Object key) {
        return getLsObj(key, null);
    }

    public List<XObj> getLsObj(Object key, List<XObj> def) {
        try {
            List<Object> lsObject = get(key);
            List<XObj> lsObj = new ArrayList<>();
            for (Object obj : lsObject) {
                try {
                    @SuppressWarnings("unchecked")
                    Map<Object, Object> value = (Map<Object, Object>) obj;
                    if (value == null) {
                        continue;
                    }
                    lsObj.add(new XObj().putAll(value));
                } catch (Throwable ex) {
                }
            }
            return lsObj;
        } catch (Throwable ex) {
        }
        return def;
    }

    public List<String> getLsStr(Object key) {
        return getLsStr(key, null);
    }

    public List<String> getLsStr(Object key, List<String> def) {
        return XCvt.toLsStr(get(key), def);
    }

    public List<Integer> getLsInt(Object key) {
        return getLsInt(key, null);
    }

    public List<Integer> getLsInt(Object key, List<Integer> def) {
        return XCvt.toLsInt(get(key), def);
    }

    public List<Long> getLsLong(Object key) {
        return getLsLong(key, null);
    }

    public List<Long> getLsLong(Object key, List<Long> def) {
        return XCvt.toLsLong(get(key), def);
    }

    public List<Float> getLsFloat(Object key) {
        return getLsFloat(key, null);
    }

    public List<Float> getLsFloat(Object key, List<Float> def) {
        return XCvt.toLsFloat(get(key), def);
    }

    public List<Double> getLsDouble(Object key) {
        return getLsDouble(key, null);
    }

    public List<Double> getLsDouble(Object key, List<Double> def) {
        return XCvt.toLsDouble(get(key), def);
    }

    public Set<String> getSetStr(Object key) {
        return getSetStr(key, null);
    }

    public Set<String> getSetStr(Object key, Set<String> def) {
        return XCvt.toSetStr(get(key), def);
    }

    public Set<Integer> getSetInt(Object key) {
        return getSetInt(key, null);
    }

    public Set<Integer> getSetInt(Object key, Set<Integer> def) {
        return XCvt.toSetInt(get(key), def);
    }

    public Set<Long> getSetLong(Object key) {
        return getSetLong(key, null);
    }

    public Set<Long> getSetLong(Object key, Set<Long> def) {
        return XCvt.toSetLong(get(key), def);
    }

    public Set<Float> getSetFloat(Object key) {
        return getSetFloat(key, null);
    }

    public Set<Float> getSetFloat(Object key, Set<Float> def) {
        return XCvt.toSetFloat(get(key), def);
    }

    public Set<Double> getSetDouble(Object key) {
        return getSetDouble(key, null);
    }

    public Set<Double> getSetDouble(Object key, Set<Double> def) {
        return XCvt.toSetDouble(get(key), def);
    }

}
