package org.xyou.xcommon.ex;

import java.lang.reflect.Field;
import java.util.Set;

import org.xyou.xcommon.reflect.XReflect;
import org.xyou.xcommon.seq.XSeq;
import org.xyou.xcommon.tool.XCls;

public final class XEx {

    public static RuntimeException createClassInvalid(Object obj) throws RuntimeException {
        return new RuntimeException("Class invalid " + XCls.getClass(obj).getName());
    }

    public static Object checkNotNull(Object obj, String... arrNameField) {
        try {
            Set<String> setNameField = XSeq.newHashSet(arrNameField);
            for (Field field : XReflect.getLsField(obj)) {
                String nameField = field.getName();
                if (!setNameField.contains(nameField)) {
                    continue;
                }
                field.setAccessible(true);
                Object value = field.get(obj);
                if (value == null) {
                    throw new RuntimeException(String.format("'%s' null", nameField));
                }
            }
            return obj;
        } catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

}
