package org.xyou.xcommon.logger;

import java.io.Serializable;

import org.xyou.xcommon.tool.XCls;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.spi.AbstractLogger;
import org.apache.logging.log4j.spi.ExtendedLoggerWrapper;

import lombok.AccessLevel;
import lombok.Getter;

public final class XLogger implements Serializable {

    private static final long serialVersionUID = 0l;

    private static final String FQCN = XLogger.class.getName();
    private static final Level ERROR = Level.forName("ERROR", 200);
    private static final Level INFO = Level.forName("INFO", 400);

    private final transient ExtendedLoggerWrapper logger;
    @Getter(AccessLevel.PUBLIC)
    private final Class<?> cls;

    public XLogger() {
        StackTraceElement eleStackTrace = new Exception().getStackTrace()[1];
        cls = XCls.getClassByNameClass(eleStackTrace.getClassName());
        Logger loggerWrapped = LogManager.getLogger(cls);
        logger = new ExtendedLoggerWrapper(
            (AbstractLogger) loggerWrapped,
            loggerWrapped.getName(),
            loggerWrapped.getMessageFactory()
        );
    }

    public void error(final Throwable cause) {
        logger.logIfEnabled(FQCN, ERROR, null, cause.getMessage(), cause);
    }

    public void error(final Object message) {
        logger.logIfEnabled(FQCN, ERROR, null, message, (Throwable) null);
    }

    public void info(final Object message) {
        logger.logIfEnabled(FQCN, INFO, null, message, (Throwable) null);
    }
}
