package org.xyou.xcommon.map;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;

import com.google.common.collect.ImmutableMap;

public final class XMap {

    public static <K, V> Map<K, V> of(K k1, V v1) {
        return ImmutableMap.of(k1, v1);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2) {
        return ImmutableMap.of(k1, v1, k2, v2);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3) {
        return ImmutableMap.of(k1, v1, k2, v2, k3, v3);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4) {
        return ImmutableMap.of(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5) {
        return ImmutableMap.of(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    public static <K, V> boolean isEmpty(Map<K, V> map) {
        if (map == null || map.isEmpty()) {
            return true;
        }
        return false;
    }

    public static <K, V> Map<V, K> reverse(Map<K, V> map) {
        Map<V, K> mapData = new HashMap<>();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            mapData.put(entry.getValue(), entry.getKey());
        }
        return mapData;
    }

    public static <K, V> List<K> getLsKeySortedByValue(Map<K, V> map) {
        List<Map.Entry<K, V>> lsEntry = new ArrayList<>(map.entrySet());
        Collections.sort(lsEntry, new Comparator<Object>() {

            @SuppressWarnings("unchecked")
            public int compare(Object o1, Object o2) {
                return ((Comparable<V>) ((Map.Entry<K, V>) (o2)).getValue())
                    .compareTo(((Map.Entry<K, V>) (o1)).getValue());
            }
        });
        List<K> lsKey = lsEntry.stream()
            .map(Map.Entry::getKey)
            .collect(Collectors.toList());
        return lsKey;
    }

    public static <K, V> List<V> getLsValueByLsKey(Map<K, V> map, Collection<K> coll) {
        List<V> lsData = new ArrayList<>();
        for (K key : coll) {
            V value = map.get(key);
            if (value == null) {
                continue;
            }
            lsData.add(value);
        }
        return lsData;
    }

    public static <K, V> Map<K, V> filterByLsKey(Map<K, V> map, Collection<K> collKey) {
        Map<K, V> mapOut = new HashMap<>();
        for (K key : collKey) {
            V value = map.get(key);
            if (value == null) {
                continue;
            }
            mapOut.put(key, value);
        }
        return mapOut;
    }

    private static <K, V> Set<K> mergeKey(List<Map<K, V>> lsMap) {
        Set<K> setKey = new HashSet<>();
        for (Map<K, V> map : lsMap) {
            setKey.addAll(map.keySet());
        }
        return setKey;
    }

    public static <K, V, T> Map<K, T> map(Map<K, V> map, Function<V, T> func) {
        Map<K, T> mapData = new HashMap<>();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            K key = entry.getKey();
            V value = entry.getValue();
            T data = func.apply(value);
            mapData.put(key, data);
        }
        return mapData;
    }

    public static <K, V> Map<K, V> reduce(List<Map<K, V>> lsMap, V def, BiFunction<V, V, V> func) {
        Map<K, V> mapData = new HashMap<>();
        Set<K> setKey = mergeKey(lsMap);
        for (K key : setKey) {
            for (Map<K, V> map : lsMap) {
                V data = mapData.getOrDefault(key, def);
                V value = map.getOrDefault(key, def);
                data = func.apply(data, value);
                mapData.put(key, data);
            }
        }
        return mapData;
    }

    public static <K extends Object, V extends Number> Map<K, Double> normLog(Map<K, V> map) {
        V max = null;

        for (V val : map.values()) {
            if (max == null || val.doubleValue() > max.doubleValue()) {
                max = val;
            }
        }

        double maxLog = 1;
        if (max.doubleValue() > 1) {
            maxLog = Math.log(max.doubleValue());
        }
        Map<K, Double> mapIdSongCountNorm = new HashMap<>();
        for (Map.Entry<K, V> keyVal : map.entrySet()) {
            K key = keyVal.getKey();
            V val = keyVal.getValue();

            mapIdSongCountNorm.put(
                key,
                Math.log(val.doubleValue()) / maxLog
            );
        }
        return mapIdSongCountNorm;
    }

    public static <K extends Object, V extends Number> Map<K, Double> normMax(Map<K, V> map) {
        V max = null;
        for (V val : map.values()) {
            if (max == null || val.doubleValue() > max.doubleValue()) {
                max = val;
            }
        }
        Map<K, Double> mapIdSongCountNorm = new HashMap<>();
        for (Map.Entry<K, V> keyVal : map.entrySet()) {
            K key = keyVal.getKey();
            V val = keyVal.getValue();
            double countNorm = val.doubleValue() / max.doubleValue();
            mapIdSongCountNorm.put(key, countNorm);
        }
        return mapIdSongCountNorm;
    }
}
