package org.xyou.xcommon.pool;

import java.util.ArrayList;
import java.util.List;

import org.xyou.xcommon.base.XBaseObject;
import org.xyou.xcommon.queue.XQueue;

import lombok.AccessLevel;
import lombok.Getter;

public final class XPool<V> extends XBaseObject {

    private static final long serialVersionUID = 1L;

    @Getter(AccessLevel.PACKAGE)
    private final transient XQueue<XPoolItem<V>> queue;

    public XPool(int sizeMax) {
        queue = new XQueue<>(sizeMax);
    }

    public boolean isFull() {
        return queue.isFull();
    }

    public boolean isEmpty() {
        return queue.isEmpty();
    }

    public int size() {
        return queue.size();
    }

    public List<XPoolItem<V>> take(int numItem) {
        return queue.take(numItem);
    }

    public XPoolItem<V> take() {
        return queue.take();
    }

    boolean offer(XPoolItem<V> item) {
        return queue.offer(item);
    }

    public boolean offer(V data) {
        return offer(new XPoolItem<>(data, this));
    }

    public List<V> unload(int numItem) {
        List<V> lsData = new ArrayList<>(numItem);
        for (int idxObject = 0; idxObject < numItem; idxObject++) {
            XPoolItem<V> item = queue.take();
            V data = item.getData();
            lsData.add(data);
        }
        return lsData;
    }
}
