package org.xyou.xcommon.pool;

import org.xyou.xcommon.base.XBaseObject;

import lombok.AccessLevel;
import lombok.Getter;
import lombok.Setter;

public final class XPoolItem<V> extends XBaseObject implements AutoCloseable {

    private static final long serialVersionUID = 1L;

    @Getter(AccessLevel.PUBLIC)
    @Setter(AccessLevel.PUBLIC)
    private V data;
    private final transient XPool<V> pool;

    public XPoolItem(V data, XPool<V> pool) {
        this.data = data;
        this.pool = pool;
    }

    @Override
    public void close() {
        pool.offer(this);
    }
}
