package org.xyou.xcommon.profiler;

import java.util.concurrent.ScheduledFuture;
import java.util.function.Supplier;

import org.xyou.xcommon.base.XBaseObject;

import lombok.AccessLevel;
import lombok.Getter;

public final class XProfilerObj extends XBaseObject {

    private static final long serialVersionUID = 1L;

    @Getter(AccessLevel.PUBLIC)
    private final String name;

    XProfilerObj(String name) {
        this.name = name;
    }

    String buildName(String name) {
        return this.name  + ":" +  name;
    }

    public double getCounter(String name) {
        return XProfiler.getCounter(buildName(name));
    }

    public void incCounter(String name) {
        XProfiler.incCounter(buildName(name));
    }

    public void incCounter(String name, double value) {
        XProfiler.incCounter(buildName(name), value);
    }

    public double getGauge(String name) {
        return XProfiler.getGauge(buildName(name));
    }

    public void setGauge(String name, double value) {
        XProfiler.setGauge(buildName(name), value);
    }

    public void incGauge(String name) {
        XProfiler.incGauge(buildName(name));
    }

    public void incGauge(String name, double value) {
        XProfiler.incGauge(buildName(name), value);
    }

    public void decGauge(String name) {
        XProfiler.decGauge(buildName(name));
    }

    public void decGauge(String name, double value) {
        XProfiler.decGauge(buildName(name), value);
    }

    public XProfilerTimer getTimer(String name) {
        return XProfiler.getTimer(buildName(name));
    }

    public ScheduledFuture<?> scheduleGauge(String name, Supplier<Number> func) {
        return XProfiler.scheduleGauge(buildName(name), func);
    }
}
