package org.xyou.xcommon.queue;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;

import org.xyou.xcommon.base.XBaseObject;
import org.xyou.xcommon.config.XConfig;
import org.xyou.xcommon.profiler.XProfiler;
import org.xyou.xcommon.profiler.XProfilerObj;

import lombok.AccessLevel;
import lombok.Getter;

public final class XQueue<V> extends XBaseObject {

    private static final long serialVersionUID = 1L;

    @Getter(AccessLevel.PUBLIC)
    private String name;
    @Getter(AccessLevel.PUBLIC)
    private Integer sizeMax;
    private Boolean isProfiler;
    private transient BlockingQueue<V> queue;
    private transient XProfilerObj objProfiler;

    public XQueue(int sizeMax) {
        name = null;
        this.sizeMax = sizeMax;
        isProfiler = false;
        queue = initQueue(sizeMax);
        objProfiler = null;
    }

    public XQueue(String name) {
        this.name = name;
        XConfig config = new XConfig(name);
        this.name = name;
        sizeMax = config.getInt("sizeMax");
        isProfiler = config.getBool("isProfiler", false);
        queue = initQueue(sizeMax);
        if (isProfiler) {
            objProfiler = XProfiler.createObj(this);
            objProfiler.scheduleGauge("size", this::size);
        }
    }

    private BlockingQueue<V> initQueue(int sizeMax) {
        return new ArrayBlockingQueue<>(sizeMax);
    }

    public boolean isFull() {
        return queue.size() == sizeMax;
    }

    public boolean isEmpty() {
        return queue.isEmpty();
    }

    public int size() {
        return queue.size();
    }

    public List<V> take(int numData) {
        List<V> lsData = new ArrayList<>();
        try {
            for (int idxData = 0; idxData < numData; idxData++) {
                V data = queue.take();
                lsData.add(data);
            }
        } catch (Throwable ex) {
        }
        return lsData;
    }

    public V take() {
        try {
            return queue.take();
        } catch (Throwable ex) {
        }
        return null;
    }

    public V poll() {
        return queue.poll();
    }

    public void put(V data) {
        try {
            queue.put(data);
        } catch (Throwable ex) {
        }
    }

    public boolean offer(V data) {
        return queue.offer(data);
    }

    public boolean remove(V data) {
        return queue.remove(data);
    }
}
