package org.xyou.xcommon.reflect;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;

import org.xyou.xcommon.tool.XCls;

public final class XReflect {

    public static boolean set(Object obj, String nameField, Object value) {
        try {
            Field field = obj.getClass().getDeclaredField(nameField);
            field.setAccessible(true);
            field.set(obj, value);
            return true;
        } catch (Throwable ex) {
        }
        return false;
    }

    public static <V> V get(Object obj, String nameField) {
        try {
            Field field = obj.getClass().getDeclaredField(nameField);
            field.setAccessible(true);
            @SuppressWarnings("unchecked")
            V value = (V) field.get(obj);
            return value;
        } catch (Throwable ex) {
        }
        return null;
    }

    public static List<Field> getLsField(Object obj) {
        Class<?> cls = XCls.getClass(obj);
        List<Field> lsField = new ArrayList<>();
        Field[] arrField = cls.getDeclaredFields();
        for (Field field : arrField) {
            int typeModifier = field.getModifiers();
            if (field.isSynthetic()) {
                continue;
            }
            if (Modifier.isStatic(typeModifier)) {
                continue;
            }
            lsField.add(field);
        }
        return lsField;
    }

    public static List<String> getLsKey(Object obj) {
        List<String> ls = new ArrayList<>();
        for (Field field : getLsField(obj)) {
            String ele = field.getName();
            ls.add(ele);
        }
        return ls;
    }

    public static List<Object> getLsValue(Object obj) {
        try {
            List<Object> ls = new ArrayList<>();
            for (Field field : getLsField(obj)) {
                field.setAccessible(true);
                Object ele = (Object) field.get(obj);
                ls.add(ele);
            }
            return ls;
        } catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

}
