package org.xyou.xcommon.tool;

import java.lang.reflect.Array;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;

import org.xyou.xcommon.seq.XSeq;

public final class XCvt {

    public static String toStr(Object in) {
        return toStr(in, null);
    }

    public static String toStr(Object in, String def) {
        try {
            if (in == null) {
                return def;
            }
            if (in instanceof Timestamp) {
                return Long.toString(((Timestamp) in).getTime() / XTime.MS_SEC);
            }
            if (in instanceof Collection) {
                StringJoiner joiner = new StringJoiner(",");
                for (Object ele : (Collection<?>) in) {
                    joiner.add(ele.toString());
                }
                return joiner.toString();
            }
            if (in instanceof Object[]) {
                try {
                    return toStr(XSeq.newArrayList((Object[]) in));
                } catch (Throwable ex) {
                }
                return "";
            }
            return in.toString();
        } catch (Throwable ex) {
        }
        return def;
    }

    public static Integer toInt(Object in) {
        return toInt(in, null);
    }

    public static Integer toInt(Object in, Integer def) {
        try {
            if (in == null) {
                return def;
            }
            if (in instanceof String) {
                String inTrim = ((String) in).trim();
                try {
                    return Integer.parseInt(inTrim);
                } catch (Throwable ex) {
                }
                return toInt(Double.parseDouble(inTrim));
            }
            return ((Number) in).intValue();
        } catch (Throwable ex) {
        }
        return def;
    }

    public static Long toLong(Object in) {
        return toLong(in, null);
    }

    public static Long toLong(Object in, Long def) {
        try {
            if (in == null) {
                return def;
            }
            if (in instanceof String) {
                String inTrim = ((String) in).trim();
                try {
                    return Long.parseLong(inTrim);
                } catch (Throwable ex) {
                }
                return toLong(Double.parseDouble(inTrim));
            }
            return ((Number) in).longValue();
        } catch (Throwable ex) {
        }
        return def;
    }

    public static Float toFloat(Object in) {
        return toFloat(in, null);
    }

    public static Float toFloat(Object in, Float def) {
        try {
            if (in == null) {
                return def;
            }
            if (in instanceof String) {
                return Float.parseFloat(((String) in).trim());
            }
            return ((Number) in).floatValue();
        } catch (Throwable ex) {
        }
        return def;
    }

    public static Double toDouble(Object in) {
        return toDouble(in, null);
    }

    public static Double toDouble(Object in, Double def) {
        try {
            if (in == null) {
                return def;
            }
            if (in instanceof String) {
                return Double.parseDouble(((String) in).trim());
            }
            return ((Number) in).doubleValue();
        } catch (Throwable ex) {
        }
        return def;
    }

    public static Boolean toBool(Object in) {
        return toBool(in, null);
    }

    public static Boolean toBool(Object in, Boolean def) {
        try {
            if (in == null) {
                return def;
            }
            if (in instanceof String) {
                String inProcess = ((String) in).trim();
                if (inProcess.equals("true")) {
                    return true;
                }
                if (inProcess.equals("false")) {
                    return false;
                }
            }
            return (Boolean) in;
        } catch (Throwable ex) {
        }
        return def;
    }

    public static Timestamp toTimestamp(Object in) {
        return toTimestamp(in, null);
    }

    public static Timestamp toTimestamp(Object in, Timestamp def) {
        try {
            if (in == null) {
                return def;
            }
            if (in instanceof Number) {
                return new Timestamp(((Number) in).longValue() * XTime.MS_SEC);
            }
            return (Timestamp) in;
        } catch (Throwable ex) {
        }
        return def;
    }

    public static List<String> toLsStr(Object in) {
        return toLsStr(in, null);
    }

    public static List<String> toLsStr(Object in, List<String> def) {
        try {
            if (in == null) {
                return def;
            }
            List<String> lsData = new ArrayList<>();
            if (in instanceof String) {
                String strLs = (String) in;
                String[] arrEle = null;
                if (strLs.contains(",")) {
                    arrEle = strLs.split(",");
                } else {
                    arrEle = XSeq.newArray(strLs);
                }
                for (String ele : arrEle) {
                    try {
                        if (XStr.isEmpty(ele)) {
                            continue;
                        }
                        lsData.add(ele);
                    } catch (Throwable ex) {
                    }
                }
                return lsData;
            }
            if (in instanceof Object[]) {
                for (Object ele : ((Object[]) in)) {
                    lsData.add(toStr(ele));
                }
                return lsData;
            }
            for (Object ele : (Collection<?>) in) {
                lsData.add(toStr(ele));
            }
            return lsData;
        } catch (Throwable ex) {
        }
        return def;
    }

    public static List<Integer> toLsInt(Object in) {
        return toLsInt(in, null);
    }

    public static List<Integer> toLsInt(Object in, List<Integer> def) {
        try {
            if (in == null) {
                return def;
            }
            List<Integer> lsData = new ArrayList<>();
            if (in instanceof int[]) {
                for (int ele : ((int[]) in)) {
                    lsData.add(ele);
                }
                return lsData;
            }
            List<String> lsStr = toLsStr(in);
            for (String eleStr : lsStr) {
                try {
                    XSeq.addEleToCollectionIfNotNull(
                        lsData,
                        toInt(eleStr)
                    );
                } catch (Throwable ex) {
                }
            }
            return lsData;
        } catch (Throwable ex) {
        }
        return def;
    }

    public static List<Long> toLsLong(Object in) {
        return toLsLong(in, null);
    }

    public static List<Long> toLsLong(Object in, List<Long> def) {
        try {
            if (in == null) {
                return def;
            }
            List<Long> lsData = new ArrayList<>();
            if (in instanceof long[]) {
                for (long ele : ((long[]) in)) {
                    lsData.add(ele);
                }
                return lsData;
            }
            List<String> lsStr = toLsStr(in);
            for (String eleStr : lsStr) {
                try {
                    XSeq.addEleToCollectionIfNotNull(
                        lsData,
                        toLong(eleStr)
                    );
                } catch (Throwable ex) {
                }
            }
            return lsData;
        } catch (Throwable ex) {
        }
        return def;
    }

    public static List<Float> toLsFloat(Object in) {
        return toLsFloat(in, null);

    }

    public static List<Float> toLsFloat(Object in, List<Float> def) {
        try {
            if (in == null) {
                return def;
            }
            List<Float> lsData = new ArrayList<>();
            if (in instanceof float[]) {
                for (float ele : ((float[]) in)) {
                    lsData.add(ele);
                }
                return lsData;
            }
            List<String> lsStr = toLsStr(in);
            for (String eleStr : lsStr) {
                try {
                    XSeq.addEleToCollectionIfNotNull(
                        lsData,
                        toFloat(eleStr)
                    );
                } catch (Throwable ex) {
                }
            }
            return lsData;
        } catch (Throwable ex) {
        }
        return def;
    }

    public static List<Double> toLsDouble(Object in) {
        return toLsDouble(in, null);
    }

    public static List<Double> toLsDouble(Object in, List<Double> def) {
        try {
            if (in == null) {
                return def;
            }
            List<Double> lsData = new ArrayList<>();
            if (in instanceof double[]) {
                for (double ele : ((double[]) in)) {
                    lsData.add(ele);
                }
                return lsData;
            }
            List<String> lsStr = toLsStr(in);
            for (String eleStr : lsStr) {
                try {
                    XSeq.addEleToCollectionIfNotNull(
                        lsData,
                        toDouble(eleStr)
                    );
                } catch (Throwable ex) {
                }
            }
            return lsData;
        } catch (Throwable ex) {
        }
        return def;
    }

    public static List<Boolean> toLsBool(Object in) {
        return toLsBool(in, null);
    }

    public static List<Boolean> toLsBool(Object in, List<Boolean> def) {
        try {
            if (in == null) {
                return def;
            }
            List<String> lsStr = toLsStr(in);
            List<Boolean> ls = new ArrayList<>();
            for (String eleStr : lsStr) {
                try {
                    XSeq.addEleToCollectionIfNotNull(
                        ls,
                        toBool(eleStr)
                    );
                } catch (Throwable ex) {
                }
            }
            return ls;
        } catch (Throwable ex) {
        }
        return def;
    }

    public static <V> List<V> toLsObject(V[] arr) {
        return toLsObject(arr, null);
    }

    public static <V> List<V> toLsObject(V[] arr, List<V> def) {
        try {
            if (arr == null) {
                return def;
            }
            return Arrays.asList(arr);
        } catch (Throwable ex) {
        }
        return null;
    }

    public static Set<String> toSetStr(Object in) {
        return toSetStr(in, null);
    }

    public static Set<String> toSetStr(Object in, Set<String> def) {
        try {
            if (in == null) {
                return def;
            }
            return new HashSet<>(toLsStr(in));
        } catch (Throwable ex) {
        }
        return def;
    }

    public static Set<Integer> toSetInt(Object in) {
        return toSetInt(in, null);
    }

    public static Set<Integer> toSetInt(Object in, Set<Integer> def) {
        try {
            if (in == null) {
                return def;
            }
            return new HashSet<>(toLsInt(in));
        } catch (Throwable ex) {
        }
        return def;
    }

    public static Set<Long> toSetLong(Object in) {
        return toSetLong(in, null);
    }

    public static Set<Long> toSetLong(Object in, Set<Long> def) {
        try {
            if (in == null) {
                return def;
            }
            return new HashSet<>(toLsLong(in));
        } catch (Throwable ex) {
        }
        return def;
    }

    public static Set<Double> toSetDouble(Object in) {
        return toSetDouble(in, null);
    }

    public static Set<Double> toSetDouble(Object in, Set<Double> def) {
        try {
            if (in == null) {
                return def;
            }
            return new HashSet<>(toLsDouble(in));
        } catch (Throwable ex) {
        }
        return def;
    }

    public static Set<Float> toSetFloat(Object in) {
        return toSetFloat(in, null);

    }

    public static Set<Float> toSetFloat(Object in, Set<Float> def) {
        try {
            if (in == null) {
                return def;
            }
            return new HashSet<>(toLsFloat(in));
        } catch (Throwable ex) {
        }
        return def;
    }

    public static Set<Boolean> toSetBool(Object in) {
        return toSetBool(in, null);
    }

    public static Set<Boolean> toSetBool(Object in, Set<Boolean> def) {
        try {
            if (in == null) {
                return def;
            }
            return new HashSet<>(toLsBool(in));
        } catch (Throwable ex) {
        }
        return def;
    }

    public static <V> V[] toArray(Collection<V> coll) {
        return toArray(coll, null);
    }

    public static <V> V[] toArray(Collection<V> coll, V[] def) {
        try {
            if (coll == null) {
                return def;
            }
            @SuppressWarnings("unchecked")
            Class<V> cls = (Class<V>) coll.iterator().next().getClass();
            @SuppressWarnings("unchecked")
            V[] arrType = (V[]) Array.newInstance(cls, 0);
            return (V[]) coll.toArray(arrType);
        } catch (Throwable ex) {
        }
        return def;
    }

}
