package org.xyou.xcommon.tool;

import org.xyou.xcommon.base.XBaseObject;
import org.xyou.xcommon.logger.XLogger;
import org.xyou.xcommon.schedule.XSchedule;
import org.xyou.xcommon.schedule.XScheduleParam;

import lombok.AccessLevel;
import lombok.Getter;

public final class XDestructor extends XBaseObject {

    private static final long serialVersionUID = 1L;

    private static final transient XLogger LOGGER = new XLogger();

    @Getter(AccessLevel.PUBLIC)
    private Boolean isCancel;
    private static transient XSchedule schedule;

    public XDestructor(long msMax) {
        isCancel = false;
        long timeStart = System.currentTimeMillis();
        schedule = new XSchedule();
        schedule.scheduleAtFixedRate(
            XScheduleParam.builder()
                .msPeriod(XTime.MS_SEC)
                .func(() -> {
                    long timeCur = System.currentTimeMillis();
                    long msPassed = timeCur - timeStart;
                    if (msPassed > msMax) {
                        LOGGER.info("Process self-destructed");
                        System.exit(-1);
                    }
                })
                .build()
        );
        LOGGER.info("Destructor started");
    }

    public void cancel() {
        if (!isCancel) {
            schedule.shutdown();
            isCancel = true;
            LOGGER.info("Destructor cancel");
        } else {
            LOGGER.info("Destructor has been cancelled");
        }
    }

}
