package org.xyou.xcommon.tool;

import java.io.File;
import java.util.List;
import java.util.stream.Collectors;

import org.xyou.xcommon.seq.XSeq;

public final class XFile {

    public static boolean touch(String path) {
        try {
            mkdir(dirname(path));
            return new File(path).createNewFile();
        } catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    public static boolean exist(String path) {
        return exist(new File(path));
    }

    private static boolean exist(File file) {
        return file.exists();
    }

    public static boolean rm(String path) {
        File file = new File(path);
        File[] arrFile = file.listFiles();
        if (!XSeq.isEmpty(arrFile)) {
            for (File fileInner : arrFile) {
                try {
                    rm(fileInner.getPath());
                } catch (Throwable ex) {
                }
            }
        }
        return file.delete();
    }

    public static String dirname(String path) {
        File file = new File(path);
        return file.getAbsoluteFile().getParent();
    }

    public static String basename(String path) {
        File file = new File(path);
        return file.getName();
    }

    public static void mkdir(String pathDir) {
        File file = new File(pathDir);
        if (exist(file)) {
            return;
        }
        if (!file.mkdirs()) {
            throw new RuntimeException("Create directory fail " + pathDir);
        }
    }

    public static List<String> ls(String path) {
        return XSeq.newArrayList(new File(path).listFiles()).stream()
            .map(File::getName)
            .collect(Collectors.toList());
    }

}
