package org.xyou.xcommon.tool;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Base64;
import java.util.Collection;
import java.util.List;

import org.xyou.xcommon.seq.XSeq;

public final class XStr {

    public static boolean isEmpty(String data) {
        if (data == null || data.isEmpty()) {
            return true;
        }
        return false;
    }

    public static String castEmptyOnNull(String data) {
        return data == null ? "" : data;
    }

    public static String encodeBase64(byte[] data) {
        return Base64.getUrlEncoder().encodeToString(data);
    }

    public static byte[] decodeBase64(String dataEncoded) {
        return Base64.getUrlDecoder().decode(dataEncoded);
    }

    public static List<String> toSnakeFromCamel(Collection<String> coll) {
        return XSeq.map(coll, XStr::toSnakeFromCamel);
    }

    public static List<String> toSnakeFromSnakeUpper(Collection<String> coll) {
        return XSeq.map(coll, XStr::toSnakeFromSnakeUpper);
    }

    public static List<String> toSnakeUpperFromSnake(Collection<String> coll) {
        return XSeq.map(coll, XStr::toSnakeUpperFromSnake);
    }

    public static List<String> toSnakeUpperFromCamel(Collection<String> coll) {
        return XSeq.map(coll, XStr::toSnakeUpperFromCamel);
    }

    public static List<String> toSnakeFromKebab(Collection<String> coll) {
        return XSeq.map(coll, XStr::toSnakeFromKebab);
    }

    public static List<String> toSnakeFromPascal(Collection<String> coll) {
        return XSeq.map(coll, XStr::toSnakeFromPascal);
    }

    public static List<String> toCamelFromPascal(Collection<String> coll) {
        return XSeq.map(coll, XStr::toCamelFromPascal);
    }

    public static List<String> toCamelFromSnake(Collection<String> coll) {
        return XSeq.map(coll, XStr::toCamelFromSnake);
    }

    public static List<String> toCamelFromSnakeUpper(Collection<String> coll) {
        return XSeq.map(coll, XStr::toCamelFromSnakeUpper);
    }

    public static List<String> toPascalFromCamel(Collection<String> coll) {
        return XSeq.map(coll, XStr::toPascalFromCamel);
    }

    public static String toSnakeFromCamel(String data) {
        StringBuilder builder = new StringBuilder();
        for (int idx = 0; idx < data.length(); idx++) {
            char character = data.charAt(idx);
            if (Character.isUpperCase(character)) {
                builder.append('_');
                builder.append(Character.toLowerCase(character));
            } else {
                builder.append(character);
            }
        }
        return builder.toString();
    }

    public static String toSnakeFromSnakeUpper(String inpt) {
        return inpt.toLowerCase();
    }

    public static String toSnakeUpperFromSnake(String inpt) {
        return inpt.toUpperCase();
    }

    public static String toSnakeUpperFromCamel(String inpt) {
        return toSnakeUpperFromSnake(toSnakeFromCamel(inpt));
    }

    public static String toSnakeFromKebab(String inpt) {
        return inpt.replace('-', '_');
    }

    public static String toSnakeFromPascal(String inpt) {
        return toSnakeFromCamel(toCamelFromPascal(inpt));
    }

    public static String toCamelFromPascal(String inpt) {
        return inpt.substring(0, 1).toLowerCase() + inpt.substring(1);
    }

    public static String toCamelFromSnake(String inpt) {
        StringBuilder builder = new StringBuilder();
        for (int idx = 0; idx < inpt.length(); idx++) {
            char character = inpt.charAt(idx);
            if (idx > 0 && character == '_') {
                builder.append(Character.toUpperCase(inpt.charAt(idx + 1)));
                idx += 1;
            } else {
                builder.append(character);
            }
        }
        return builder.toString();
    }

    public static String toCamelFromSnakeUpper(String inpt) {
        return toCamelFromSnake(toSnakeFromSnakeUpper(inpt));
    }

    public static String toPascalFromCamel(String inpt) {
        return inpt.substring(0, 1).toLowerCase() + inpt.substring(1);
    }

    public static String sliceEdge(String inpt) {
        return inpt.substring(1, inpt.length() - 1);
    }

    public static String buildStr(InputStream stream) {
        try {
            StringBuilder builder = new StringBuilder();
            try (Reader reader = new BufferedReader(new InputStreamReader(stream))) {
                int c = -1;
                while ((c = reader.read()) != -1) {
                    builder.append((char) c);
                }
            }
            if (builder.length() == 0) {
                return null;
            }
            return builder.toString();
        } catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

}
