package org.xyou.xcommon.tool;

import java.text.SimpleDateFormat;
import java.util.Date;

public final class XTime {

    public static final String FM_SLASH_YM = "yyyy/MM";
    public static final String FM_SLASH_YMD = FM_SLASH_YM + "/dd";
    public static final String FM_SLASH_YMDH = FM_SLASH_YMD + "/HH";
    public static final String FM_SLASH_YMDHM = FM_SLASH_YMDH + "/mm";
    public static final String FM_SLASH_YMDHMS = FM_SLASH_YMDHM + "/ss";
    public static final String FM_HYPHEN_YMD = "yyyy-MM-dd";
    public static final String FM_HYPHEN_YMDH = FM_HYPHEN_YMD + "-HH";
    public static final String FM_YMD = "yyyyMMdd";
    public static final String FM_YMDH = FM_YMD + "HH";
    public static final String FORMAT_DATE_TIME = "yyyy-MM-dd HH:mm:ss.SSS";

    public static final long SEC_MIN = 60;
    public static final long SEC_HR = 60 * SEC_MIN;
    public static final long SEC_DAY = 24 * SEC_HR;
    public static final long SEC_WEEK = 7 * SEC_DAY;
    public static final long SEC_MONTH = 30 * SEC_DAY;
    public static final long SEC_YEAR = 365 * SEC_DAY;

    public static final long MS_SEC = 1000;
    public static final long MS_MIN = 60 * MS_SEC;
    public static final long MS_HR = 60 * MS_MIN;
    public static final long MS_DAY = 24 * MS_HR;
    public static final long MS_WEEK = 7 * MS_DAY;
    public static final long MS_MONTH = 30 * MS_DAY;
    public static final long MS_YEAR = 365 * MS_DAY;

    public static final long US_SEC = 1000000;
    public static final long US_MIN = 60 * US_SEC;
    public static final long US_HR = 60 * MS_MIN;
    public static final long US_DAY = 24 * US_HR;
    public static final long US_WEEK = 7 * US_DAY;
    public static final long US_MONTH = 30 * US_DAY;
    public static final long US_YEAR = 365 * US_DAY;

    public static final long NS_US = 1000;
    public static final long NS_MS = 1000 * NS_US;
    public static final long NS_SEC = 1000 * NS_MS;
    public static final long NS_MIN = 60 * NS_SEC;
    public static final long NS_HR = 60 * NS_MIN;
    public static final long NS_DAY = 24 * NS_HR;
    public static final long NS_WEEK = 7 * NS_DAY;
    public static final long NS_MONTH = 30 * NS_DAY;
    public static final long NS_YEAR = 365 * NS_DAY;

    public static final Long TIME_START = XTime.getCurMs();
    public static final String TIME_START_STR = XTime.toStrMs(TIME_START, FM_SLASH_YMDHMS);

    public static long truncate(long timestamp, long timestampRef) {
        return timestamp / timestampRef;
    }

    public static long round(long timestamp, long timestampRef) {
        return truncate(timestamp, timestampRef) * timestampRef;
    }

    public static long normWeekSec(long timestampSec) {
        return normWeekSec(timestampSec, 0);
    }

    public static long normWeekSec(long timestampSec, long timestampRefSec) {
        return normWeekMs(timestampSec * MS_SEC, timestampRefSec * MS_SEC) / MS_SEC;
    }

    public static long normWeekMs(long timestampMs) {
        return normWeekMs(timestampMs, 0);
    }

    public static long normWeekMs(long timestampMs, long timestampRefMs) {
        long timeNorm = timestampMs % MS_WEEK;
        long timeRefNorm = timestampRefMs % MS_WEEK;
        if (timeNorm < timeRefNorm) {
            timeNorm += MS_WEEK;
        }
        return timeNorm;
    }

    public static long getCurMs() {
        return System.currentTimeMillis();
    }

    public static long getCurSec() {
        return getCurMs() / MS_SEC;
    }

    public static Long fromStrMs(String timeStr, String format) {
        try {
            SimpleDateFormat dateFormatter = new SimpleDateFormat(format);
            Date date = dateFormatter.parse(timeStr);
            long timestamp = date.getTime();
            return timestamp;
        } catch (Throwable ex) {
        }
        return null;
    }

    public static Long fromStrSec(String timeStr, String format) {
        try {
            return fromStrMs(timeStr, format) / MS_SEC;
        } catch (Throwable ex) {
        }
        return null;
    }

    public static String toStrMs(long timestampMs, String format) {
        try {
            SimpleDateFormat formatter = new SimpleDateFormat(format);
            Date date = new Date(timestampMs);
            String timeStr = formatter.format(date);
            return timeStr;
        } catch (Throwable ex) {
        }
        return null;
    }

    public static String toStrSec(long timestampSec, String format) {
        try {
            return toStrMs(timestampSec * MS_SEC, format);
        } catch (Throwable ex) {
        }
        return null;
    }
}
