package org.xyou.xcommon.txt;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import java.util.function.Consumer;


public final class XTxtReader {

    public static List<String> readLineAll(String path) {
        List<String> lsLine = new ArrayList<>();
        readLine(path, line -> lsLine.add(line));
        return lsLine;
    }

    public static boolean readLine(String path, Consumer<String> func) {
        try {
            File file = new File(path);
            try (Scanner scanner = new Scanner(file)) {
                while (scanner.hasNext()) {
                    String line = scanner.nextLine();
                    func.accept(line);
                }
            }
            return true;
        } catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

}
