package org.xyou.xcommon.txt;

import java.io.FileWriter;
import java.util.List;
import java.util.StringJoiner;

import org.xyou.xcommon.base.XBaseObject;
import org.xyou.xcommon.tool.XFile;

import lombok.AccessLevel;
import lombok.Getter;

public final class XTxtWriter extends XBaseObject implements AutoCloseable {

    private static final long serialVersionUID = 1L;

    @Getter(AccessLevel.PUBLIC)
    private String path;
    private FileWriter writer;

    public XTxtWriter(String path) {
        try {
            this.path = path;
            String pathDirParent = XFile.dirname(path);
            XFile.mkdir(pathDirParent);
            writer = new FileWriter(path);
        } catch (Throwable ex) {
            new RuntimeException(ex);
        }
    }

    public boolean write(Object obj) {
        return write(obj, "");
    }

    public boolean writeLine(List<Object> lsObj) {
        StringJoiner joiner = new StringJoiner("\t");
        lsObj.stream().forEach(ele -> {
            joiner.add(ele.toString());
        });
        return writeLine(joiner);
    }

    public boolean writeLine(Object obj) {
        return write(obj, "\n");
    }

    public boolean write(Object obj, String suffix) {
        try {
            writer.write(obj.toString() + suffix);
            return true;
        } catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void close() {
        try {
            if (writer == null) {
                return;
            }
            writer.close();
            writer = null;
            return;
        } catch (Throwable ex) {
        }
        return;
    }

}
