/*
 * Decompiled with CFR 0.152.
 */
package org.xyou.xcommon.base;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.xyou.xcommon.base.XBaseObject;
import org.xyou.xcommon.map.XMap;
import org.xyou.xcommon.tool.XStr;

public abstract class XBaseType
extends XBaseObject {
    private static final long serialVersionUID = 1L;
    private final String nameDefault;
    private transient List<Integer> lsId;
    private transient List<String> lsName;
    private transient Set<Integer> setId;
    private transient Set<String> setName;
    private transient Map<Integer, String> mapIdName;
    private transient Map<String, Integer> mapNameId;

    protected XBaseType() {
        this(null);
    }

    protected XBaseType(String nameDefault) {
        this.nameDefault = nameDefault;
        this.mapIdName = new HashMap<Integer, String>();
        this.lsId = new ArrayList<Integer>();
        for (Field field : this.getClass().getDeclaredFields()) {
            try {
                int typeModifier;
                if (field.isSynthetic() || !Modifier.isStatic(typeModifier = field.getModifiers()) || !Modifier.isPublic(typeModifier)) continue;
                field.setAccessible(true);
                String name = field.getName();
                name = name.toUpperCase();
                Integer id = field.getInt(null);
                this.mapIdName.put(id, name);
                this.lsId.add(id);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.lsName = XMap.getLsValueByLsKey(this.mapIdName, this.lsId);
        this.setId = new HashSet<Integer>(this.lsId);
        this.setName = new HashSet<String>(this.lsName);
        this.mapNameId = XMap.reverse(this.mapIdName);
        this.lsId = Collections.unmodifiableList(this.lsId);
        this.lsName = Collections.unmodifiableList(this.lsName);
        this.setId = Collections.unmodifiableSet(this.setId);
        this.setName = Collections.unmodifiableSet(this.setName);
        this.mapIdName = Collections.unmodifiableMap(this.mapIdName);
        this.mapNameId = Collections.unmodifiableMap(this.mapNameId);
    }

    public Integer getId(String name) {
        if (XStr.isEmpty(name)) {
            return null;
        }
        String nameUpperCase = name.toUpperCase();
        return this.mapNameId.get(nameUpperCase);
    }

    public String getName(int id) {
        return this.mapIdName.getOrDefault(id, this.nameDefault);
    }

    public String getNameDefault() {
        return this.nameDefault;
    }

    public List<Integer> getLsId() {
        return this.lsId;
    }

    public List<String> getLsName() {
        return this.lsName;
    }

    public Set<Integer> getSetId() {
        return this.setId;
    }

    public Set<String> getSetName() {
        return this.setName;
    }

    public Map<Integer, String> getMapIdName() {
        return this.mapIdName;
    }

    public Map<String, Integer> getMapNameId() {
        return this.mapNameId;
    }
}

