/*
 * Decompiled with CFR 0.152.
 */
package org.xyou.xcommon.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.xyou.xcommon.base.XBaseObject;
import org.xyou.xcommon.config.XConfig;
import org.xyou.xcommon.profiler.XProfiler;
import org.xyou.xcommon.profiler.XProfilerObj;
import org.xyou.xcommon.tool.XCvt;
import org.xyou.xcommon.tool.XLockMap;
import org.xyou.xcommon.tool.XTime;

public final class XCache<K, V>
extends XBaseObject {
    private static final long serialVersionUID = 1L;
    private String name;
    private Integer sizeMax;
    private Integer setExpire;
    private Integer sizeMaxNull;
    private Integer secExpireNull;
    private Boolean isProfiler;
    private transient XLockMap poolLock;
    private transient Cache<K, V> cache;
    private transient Cache<K, Integer> cacheNull;
    private transient XProfilerObj objProfiler;

    public XCache(String name) {
        XConfig config = new XConfig(name);
        this.name = name;
        this.sizeMax = config.getInt("sizeMax");
        this.setExpire = config.getInt("secExpire");
        this.sizeMaxNull = config.getInt("sizeMaxNull", null);
        this.secExpireNull = config.getInt("secExpireNull", null);
        this.isProfiler = config.getBool("isProfiler", false);
        this.poolLock = new XLockMap();
        this.cache = CacheBuilder.newBuilder().maximumSize((long)this.sizeMax.intValue()).expireAfterWrite((long)this.setExpire.intValue(), TimeUnit.SECONDS).build();
        if (this.sizeMaxNull != null && this.secExpireNull != null) {
            this.cacheNull = CacheBuilder.newBuilder().maximumSize((long)this.sizeMaxNull.intValue()).expireAfterWrite((long)this.secExpireNull.intValue(), TimeUnit.SECONDS).build();
        }
        if (this.isProfiler.booleanValue()) {
            this.objProfiler = XProfiler.createObj(this);
            this.objProfiler.scheduleGauge("size", this::size);
            this.objProfiler.scheduleGauge("sizeNull", this::sizeNull);
        }
    }

    public V get(K key, Supplier<V> func) {
        return this.get(key, func, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(K key, Supplier<V> func, boolean isForceLoad) {
        if (key == null) {
            throw new RuntimeException("Key null");
        }
        if (this.isProfiler.booleanValue()) {
            this.objProfiler.incCounter("count_request");
        }
        Object value = null;
        if (!isForceLoad) {
            value = this.cache.getIfPresent(key);
            if (value != null) {
                if (this.isProfiler.booleanValue()) {
                    this.objProfiler.incCounter("count_hit");
                }
                return (V)value;
            }
            if (this.cacheNull != null && this.cacheNull.getIfPresent(key) != null) {
                if (this.isProfiler.booleanValue()) {
                    this.objProfiler.incCounter("count_hit_null");
                }
                return (V)value;
            }
        }
        Object object = this.poolLock.get(key);
        synchronized (object) {
            if (!isForceLoad && (value = this.cache.getIfPresent(key)) != null) {
                if (this.isProfiler.booleanValue()) {
                    this.objProfiler.incCounter("count_hit");
                }
                return (V)value;
            }
            if (this.isProfiler.booleanValue()) {
                this.objProfiler.incCounter("count_load");
            }
            if ((value = func.get()) != null) {
                if (this.isProfiler.booleanValue()) {
                    this.objProfiler.incCounter("count_load_success");
                }
                this.put(key, value);
                return (V)value;
            }
            if (this.cacheNull != null) {
                this.cacheNull.put(key, (Object)XCvt.toInt(XTime.getCurSec()));
            }
        }
        return (V)value;
    }

    public void put(K key, V value) {
        if (key == null) {
            throw new RuntimeException("Key null");
        }
        if (value == null) {
            throw new RuntimeException("Value null");
        }
        this.cache.put(key, value);
    }

    public Long size() {
        return this.cache.size();
    }

    public Long sizeNull() {
        return this.cacheNull.size();
    }

    public String getName() {
        return this.name;
    }

    public Integer getSizeMax() {
        return this.sizeMax;
    }

    public Integer getSetExpire() {
        return this.setExpire;
    }

    public Integer getSizeMaxNull() {
        return this.sizeMaxNull;
    }

    public Integer getSecExpireNull() {
        return this.secExpireNull;
    }

    public Boolean getIsProfiler() {
        return this.isProfiler;
    }

    XProfilerObj getObjProfiler() {
        return this.objProfiler;
    }
}

