/*
 * Decompiled with CFR 0.152.
 */
package org.xyou.xcommon.codec;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.stream.Collectors;
import org.xyou.xcommon.codec.Model;
import org.xyou.xcommon.tool.XStr;

public final class XCodec {
    public static boolean isValidId(Object id) {
        if (id instanceof String) {
            return true;
        }
        if (id instanceof Number) {
            Long idLong = ((Number)id).longValue();
            return idLong >= 1L;
        }
        return false;
    }

    public static List<String> encodeIdInt(List<Integer> lsId, int salt) {
        try {
            return lsId.stream().map(id -> XCodec.encodeIdInt(id, salt)).filter(ele -> ele != null).collect(Collectors.toList());
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static List<String> encodeIdLong(List<Long> lsId, int salt) {
        try {
            return lsId.stream().map(id -> XCodec.encodeIdLong(id, salt)).filter(ele -> ele != null).collect(Collectors.toList());
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static List<Integer> decodeIdInt(List<String> lsId, int salt) {
        try {
            return lsId.stream().map(id -> XCodec.decodeIdInt(id, salt)).filter(ele -> ele != null).collect(Collectors.toList());
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static List<Long> decodeIdLong(List<String> lsId, int salt) {
        try {
            return lsId.stream().map(id -> XCodec.decodeIdLong(id, salt)).filter(ele -> ele != null).collect(Collectors.toList());
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static String encodeIdLong(Long id, int salt) {
        if (!XCodec.isValidId(id)) {
            return null;
        }
        byte[] arrByte = ByteBuffer.allocate(8).putLong(id ^ (long)salt).array();
        return XCodec.encodeIdByte(arrByte);
    }

    public static String encodeIdInt(Integer id, int salt) {
        if (!XCodec.isValidId(id)) {
            return null;
        }
        byte[] arrByte = ByteBuffer.allocate(4).putInt(id ^ salt).array();
        return XCodec.encodeIdByte(arrByte);
    }

    public static String encodeIdByte(byte[] id) {
        String encoded = XStr.encodeBase64(id);
        encoded = Model.getInst().encode(encoded);
        String encodedNoPad = encoded.substring(0, encoded.length() - 2);
        return Model.getInst().getPrefix() + encodedNoPad;
    }

    public static Long decodeIdLong(String idEncoded, int salt) {
        if (XStr.isEmpty(idEncoded)) {
            return null;
        }
        String idEncodedPad = idEncoded + "==";
        String decoded = Model.getInst().decode(idEncodedPad.substring(Model.getInst().getPrefix().length()));
        byte[] arrByte = XStr.decodeBase64(decoded);
        return ByteBuffer.wrap(arrByte).getLong() ^ (long)salt;
    }

    public static Integer decodeIdInt(String idEncoded, int salt) {
        if (XStr.isEmpty(idEncoded)) {
            return null;
        }
        String idEncodedPad = idEncoded + "==";
        String decoded = Model.getInst().decode(idEncodedPad.substring(Model.getInst().getPrefix().length()));
        byte[] arrByte = XStr.decodeBase64(decoded);
        return ByteBuffer.wrap(arrByte).getInt() ^ salt;
    }
}

