/*
 * Decompiled with CFR 0.152.
 */
package org.xyou.xcommon.config;

import java.net.JarURLConnection;
import java.util.Collections;
import java.util.jar.JarFile;
import org.ini4j.Profile;
import org.ini4j.Wini;
import org.xyou.xcommon.config.XConfig;
import org.xyou.xcommon.entity.XObj;
import org.xyou.xcommon.file.XFile;
import org.xyou.xcommon.logger.XLogger;
import org.xyou.xcommon.tool.XUrl;
import org.xyou.xcommon.yaml.XYaml;

final class Model {
    private final transient XLogger logger = new XLogger(XConfig.class);
    private final transient XObj mapSection = new XObj();

    static Model getInst() {
        return Holder.INST;
    }

    private Model() {
        try {
            Collections.list(ClassLoader.getSystemResources("conf/production.config.ini")).forEach(url -> {
                try {
                    this.logger.info("Read ini " + url.getPath());
                    new Wini(url).entrySet().forEach(entrySection -> {
                        XObj section = new XObj();
                        ((Profile.Section)entrySection.getValue()).entrySet().forEach(entry -> section.put(entry.getKey(), entry.getValue()));
                        this.put(entrySection.getKey(), section);
                    });
                }
                catch (Throwable ex) {
                    throw new RuntimeException(ex);
                }
            });
            String nameDir = "xconfig";
            Collections.list(ClassLoader.getSystemResources(nameDir)).forEach(urlDir -> {
                block15: {
                    try {
                        String pathDir = urlDir.getPath();
                        this.logger.info("At " + pathDir);
                        if (XFile.exist(pathDir)) {
                            XFile.ls(pathDir).forEach(name -> this.addConfig(pathDir + "/" + name));
                            break block15;
                        }
                        try (JarFile file = ((JarURLConnection)urlDir.openConnection()).getJarFile();){
                            Collections.list(file.entries()).forEach(ele -> {
                                String name = ele.getName();
                                if (!XFile.basename(XFile.dirname(name)).equals(nameDir)) {
                                    return;
                                }
                                this.addConfig(XUrl.init(urlDir + "/" + XFile.basename(name)));
                            });
                        }
                    }
                    catch (Throwable ex) {
                        throw new RuntimeException(ex);
                    }
                }
            });
        }
        catch (Throwable ex) {
            this.logger.error(ex);
        }
    }

    private void addConfig(Object url) {
        try {
            this.logger.info("Read " + url);
            XYaml.fromFile(url, XObj.class).getMap().entrySet().forEach(entrySection -> this.put(entrySection.getKey(), entrySection.getValue()));
        }
        catch (Throwable ex) {
            this.logger.error("Read fail " + url);
            this.logger.error(ex);
        }
    }

    private void put(Object key, Object section) {
        if (this.mapSection.containsKey(key)) {
            this.logger.info("Overwrite section " + key);
        } else {
            this.logger.info("Read section " + key);
        }
        this.mapSection.put(key, section);
    }

    XObj getMapSection() {
        return this.mapSection;
    }

    private static class Holder {
        public static final Model INST = new Model();

        private Holder() {
        }
    }
}

