/*
 * Decompiled with CFR 0.152.
 */
package org.xyou.xcommon.config;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.xyou.xcommon.base.XBaseObject;
import org.xyou.xcommon.config.Model;
import org.xyou.xcommon.entity.XObj;
import org.xyou.xcommon.tool.XCls;
import org.xyou.xcommon.tool.XCvt;

public final class XConfig
extends XBaseObject {
    private static final long serialVersionUID = 1L;
    private final Class<?> cls;
    private final String name;
    private final String keyConf;
    private final transient XObj section;
    private final transient String prefixMsg;

    public XConfig(String name) {
        this.name = name;
        this.cls = XCls.getClassByTrace(1);
        String nameClass = this.cls.getSimpleName();
        this.keyConf = nameClass + "@" + name;
        Object data = Model.getInst().getMapSection().get(this.keyConf);
        this.prefixMsg = String.format("Config '%s'", this.keyConf);
        if (data == null) {
            throw new RuntimeException(this.prefixMsg + " missing");
        }
        this.section = new XObj().putAll(data);
    }

    public <V> V check(String key, V value) {
        String prefixMsgKey = String.format(this.prefixMsg + " key '%s'", key);
        if (!this.section.containsKey(key)) {
            throw new RuntimeException(prefixMsgKey + " missing");
        }
        if (value == null) {
            throw new RuntimeException(prefixMsgKey + " value invalid");
        }
        return value;
    }

    public String getStr(String key) {
        return this.check(key, this.getStr(key, null));
    }

    public String getStr(String key, String def) {
        return this.section.getStr(key, def);
    }

    public Integer getInt(String key) {
        return this.check(key, this.getInt(key, null));
    }

    public Integer getInt(String key, Integer def) {
        return XCvt.toInt(this.getStr(key, null), def);
    }

    public Long getLong(String key) {
        return this.check(key, this.getLong(key, null));
    }

    public Long getLong(String key, Long def) {
        return XCvt.toLong(this.getStr(key, null), def);
    }

    public Float getFloat(String key) {
        return this.check(key, this.getFloat(key, null));
    }

    public Float getFloat(String key, Float def) {
        return XCvt.toFloat(this.getStr(key, null), def);
    }

    public Double getDouble(String key) {
        return this.check(key, this.getDouble(key, null));
    }

    public Double getDouble(String key, Double def) {
        return XCvt.toDouble(this.getStr(key, null), def);
    }

    public Boolean getBool(String key) {
        return this.check(key, this.getBool(key, null));
    }

    public Boolean getBool(String key, Boolean def) {
        return XCvt.toBool(this.getStr(key, null), def);
    }

    public List<String> getLsStr(String key) {
        return this.check(key, this.getLsStr(key, null));
    }

    public List<String> getLsStr(String key, List<String> def) {
        return XCvt.toLsStr(this.getStr(key, null), def);
    }

    public List<Integer> getLsInt(String key) {
        return this.check(key, this.getLsInt(key, null));
    }

    public List<Integer> getLsInt(String key, List<Integer> def) {
        try {
            return Collections.unmodifiableList(XCvt.toLsInt(this.getStr(key)));
        }
        catch (Throwable throwable) {
            return def;
        }
    }

    public List<Long> getLsLong(String key) {
        return this.check(key, this.getLsLong(key, null));
    }

    public List<Long> getLsLong(String key, List<Long> def) {
        try {
            return Collections.unmodifiableList(XCvt.toLsLong(this.getStr(key)));
        }
        catch (Throwable throwable) {
            return def;
        }
    }

    public List<Float> getLsFloat(String key) {
        return this.check(key, this.getLsFloat(key, null));
    }

    public List<Float> getLsFloat(String key, List<Float> def) {
        try {
            return Collections.unmodifiableList(XCvt.toLsFloat(this.getStr(key)));
        }
        catch (Throwable throwable) {
            return def;
        }
    }

    public List<Double> getLsDouble(String key) {
        return this.check(key, this.getLsDouble(key, null));
    }

    public List<Double> getLsDouble(String key, List<Double> def) {
        try {
            return Collections.unmodifiableList(XCvt.toLsDouble(this.getStr(key)));
        }
        catch (Throwable throwable) {
            return def;
        }
    }

    public List<Boolean> getLsBool(String key) {
        return this.check(key, this.getLsBool(key, null));
    }

    public List<Boolean> getLsBool(String key, List<Boolean> def) {
        try {
            return Collections.unmodifiableList(XCvt.toLsBool(this.getStr(key)));
        }
        catch (Throwable throwable) {
            return def;
        }
    }

    public Set<String> getSetStr(String key) {
        return this.check(key, this.getSetStr(key, null));
    }

    public Set<String> getSetStr(String key, Set<String> def) {
        try {
            return Collections.unmodifiableSet(XCvt.toSetStr(this.getStr(key)));
        }
        catch (Throwable throwable) {
            return def;
        }
    }

    public Set<Integer> getSetInt(String key) {
        return this.check(key, this.getSetInt(key, null));
    }

    public Set<Integer> getSetInt(String key, Set<Integer> def) {
        try {
            return Collections.unmodifiableSet(XCvt.toSetInt(this.getStr(key)));
        }
        catch (Throwable throwable) {
            return def;
        }
    }

    public Set<Long> getSetLong(String key) {
        return this.check(key, this.getSetLong(key, null));
    }

    public Set<Long> getSetLong(String key, Set<Long> def) {
        try {
            return Collections.unmodifiableSet(XCvt.toSetLong(this.getStr(key)));
        }
        catch (Throwable throwable) {
            return def;
        }
    }

    public Set<Float> getSetFloat(String key) {
        return this.check(key, this.getSetFloat(key, null));
    }

    public Set<Float> getSetFloat(String key, Set<Float> def) {
        try {
            return Collections.unmodifiableSet(XCvt.toSetFloat(this.getStr(key)));
        }
        catch (Throwable throwable) {
            return def;
        }
    }

    public Set<Double> getSetDouble(String key) {
        return this.check(key, this.getSetDouble(key, null));
    }

    public Set<Double> getSetDouble(String key, Set<Double> def) {
        try {
            return Collections.unmodifiableSet(XCvt.toSetDouble(this.getStr(key)));
        }
        catch (Throwable throwable) {
            return def;
        }
    }

    public Set<Boolean> getSetBool(String key) {
        return this.check(key, this.getSetBool(key, null));
    }

    public Set<Boolean> getSetBool(String key, Set<Boolean> def) {
        try {
            return Collections.unmodifiableSet(XCvt.toSetBool(this.getStr(key)));
        }
        catch (Throwable throwable) {
            return def;
        }
    }

    public Class<?> getCls() {
        return this.cls;
    }

    public String getName() {
        return this.name;
    }

    public String getKeyConf() {
        return this.keyConf;
    }
}

