/*
 * Decompiled with CFR 0.152.
 */
package org.xyou.xcommon.file;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.xyou.xcommon.ex.XEx;
import org.xyou.xcommon.file.Model;
import org.xyou.xcommon.seq.XSeq;
import org.xyou.xcommon.txt.XTxtReader;

public final class XFile {
    public static void touch(String path) {
        try {
            XFile.mkdir(XFile.dirname(path));
            new File(path).createNewFile();
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    public static boolean isfile(String path) {
        return new File(path).isFile();
    }

    public static boolean isdir(String path) {
        return new File(path).isDirectory();
    }

    public static boolean exist(String path) {
        return new File(path).exists();
    }

    public static void rm(String path) {
        File file = new File(path);
        File[] arrFile = file.listFiles();
        if (!XSeq.isEmpty(arrFile)) {
            for (File fileInner : arrFile) {
                try {
                    XFile.rm(fileInner.getPath());
                }
                catch (Throwable ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
        file.delete();
    }

    public static String normpath(String path) {
        return Paths.get("/", path).normalize().toString();
    }

    public static String realpath(String path) {
        File file = new File(path);
        return file.getAbsoluteFile().getPath();
    }

    public static String dirname(String path) {
        File file = new File(path);
        return file.getAbsoluteFile().getParent();
    }

    public static String basename(String path) {
        File file = new File(path);
        return file.getName();
    }

    public static void mkdir(String pathDir) {
        if (XFile.exist(pathDir)) {
            return;
        }
        if (!new File(pathDir).mkdirs()) {
            throw new RuntimeException("Create directory fail " + pathDir);
        }
    }

    public static boolean empty(String path) {
        if (XFile.isfile(path)) {
            return XTxtReader.readAll(path).equals("");
        }
        if (XFile.isdir(path)) {
            return XFile.ls(path).size() == 0;
        }
        throw new RuntimeException("Not exist " + path);
    }

    public static List<String> ls(String dir) {
        if (!XFile.isdir(dir)) {
            throw new RuntimeException("No directory " + dir);
        }
        return XSeq.newArrayList(new File(dir).listFiles()).stream().map(File::getName).collect(Collectors.toList());
    }

    public static List<String> walk(String dir) {
        ArrayList<String> lsPathAll = new ArrayList<String>();
        XFile.ls(dir).forEach(name -> {
            lsPathAll.add((String)name);
            String path = dir + "/" + name;
            if (!XFile.isdir(path)) {
                return;
            }
            XFile.walk(path).forEach(nameInner -> {
                String pathInner = name + "/" + nameInner;
                lsPathAll.add(pathInner);
            });
        });
        return lsPathAll;
    }

    public static String mime(String path) {
        return Model.getInst().getTika().detect(path);
    }

    public static void cp(Object from, Object to) {
        try {
            if (to instanceof OutputStream) {
                OutputStream streamTo = (OutputStream)to;
                Files.copy(Paths.get((String)from, new String[0]), streamTo);
                streamTo.flush();
                return;
            }
            if (to instanceof String) {
                if (from instanceof InputStream) {
                    String pathTo = (String)to;
                    Files.copy((InputStream)from, Paths.get(pathTo, new String[0]), StandardCopyOption.REPLACE_EXISTING);
                    return;
                }
                String pathFrom = (String)from;
                String pathTo = (String)to;
                XFile.mkdir(XFile.dirname(pathTo));
                if (XFile.isdir(pathFrom)) {
                    XFile.ls(pathFrom).forEach(name -> XFile.cp(pathFrom + "/" + name, pathTo + "/" + name));
                    return;
                }
                Files.copy(Paths.get(pathFrom, new String[0]), Paths.get(pathTo, new String[0]), StandardCopyOption.REPLACE_EXISTING);
                return;
            }
            throw XEx.createClassInvalid(to);
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void mv(String from, String to) {
        try {
            XFile.rm(to);
            XFile.mkdir(XFile.dirname(to));
            Files.move(Paths.get(from, new String[0]), Paths.get(to, new String[0]), new CopyOption[0]);
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }
}

