/*
 * Decompiled with CFR 0.152.
 */
package org.xyou.xcommon.logger;

import java.io.Serializable;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.spi.AbstractLogger;
import org.apache.logging.log4j.spi.ExtendedLogger;
import org.apache.logging.log4j.spi.ExtendedLoggerWrapper;
import org.xyou.xcommon.tool.XCls;

public final class XLogger
implements Serializable {
    private static final long serialVersionUID = 0L;
    private static final String FQCN = XLogger.class.getName();
    private static final Level ERROR = Level.forName((String)"ERROR", (int)200);
    private static final Level INFO = Level.forName((String)"INFO", (int)400);
    private transient ExtendedLoggerWrapper logger;
    private Class<?> cls;

    public XLogger() {
        this.cls = XCls.getClassByTrace(1);
        this.init(this.cls);
    }

    public XLogger(Class<?> cls) {
        this.init(cls);
    }

    public void init(Class<?> cls) {
        this.cls = cls;
        Logger loggerWrapped = LogManager.getLogger(cls);
        this.logger = new ExtendedLoggerWrapper((ExtendedLogger)((AbstractLogger)loggerWrapped), loggerWrapped.getName(), loggerWrapped.getMessageFactory());
    }

    public void error(Throwable cause) {
        this.logger.logIfEnabled(FQCN, ERROR, null, cause.getMessage(), cause);
    }

    public void error(Object message) {
        this.logger.logIfEnabled(FQCN, ERROR, null, message, (Throwable)null);
    }

    public void info(Object message) {
        this.logger.logIfEnabled(FQCN, INFO, null, message, (Throwable)null);
    }

    public Class<?> getCls() {
        return this.cls;
    }
}

