/*
 * Decompiled with CFR 0.152.
 */
package org.xyou.xcommon.mag;

import java.util.List;
import java.util.function.Supplier;
import org.xyou.xcommon.base.XBaseObject;
import org.xyou.xcommon.pool.XPool;
import org.xyou.xcommon.pool.XPoolItem;

public final class XMag<V>
extends XBaseObject {
    private static final long serialVersionUID = 1L;
    private final Integer sizeMax;
    private final transient Supplier<V> createData;
    private final transient XPool<V> pool;

    public XMag(int sizeMax, Supplier<V> createData) {
        this.sizeMax = sizeMax;
        this.createData = createData;
        this.pool = new XPool(sizeMax);
        this.load();
    }

    private void load() {
        for (int idxObj = 0; idxObj < this.sizeMax; ++idxObj) {
            V obj = this.createData.get();
            this.pool.offer(obj);
        }
    }

    public boolean isFull() {
        return this.pool.isFull();
    }

    public boolean isEmpty() {
        return this.pool.isEmpty();
    }

    public int size() {
        return this.pool.size();
    }

    public List<XPoolItem<V>> take(int numItem) {
        return this.pool.take(numItem);
    }

    public XPoolItem<V> take() {
        return this.pool.take();
    }

    public synchronized List<V> reload() {
        List<V> lsData = this.pool.unload(this.sizeMax);
        this.load();
        return lsData;
    }

    public Integer getSizeMax() {
        return this.sizeMax;
    }
}

