/*
 * Decompiled with CFR 0.152.
 */
package org.xyou.xcommon.map;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class XMap {
    public static <K, V> Map<K, V> of(K k1, V v1) {
        return ImmutableMap.of(k1, v1);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2) {
        return ImmutableMap.of(k1, v1, k2, v2);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3) {
        return ImmutableMap.of(k1, v1, k2, v2, k3, v3);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4) {
        return ImmutableMap.of(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5) {
        return ImmutableMap.of(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    public static <K, V> boolean isEmpty(Map<K, V> map) {
        return map == null || map.isEmpty();
    }

    public static <K, V> Map<V, K> reverse(Map<K, V> map) {
        HashMap mapData = new HashMap();
        map.entrySet().forEach(entry -> mapData.put(entry.getValue(), entry.getKey()));
        return mapData;
    }

    public static <K, V> List<K> getLsKeySortedByValue(Map<K, V> map) {
        ArrayList<Map.Entry<K, V>> lsEntry = new ArrayList<Map.Entry<K, V>>(map.entrySet());
        Collections.sort(lsEntry, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                return ((Comparable)((Map.Entry)o2).getValue()).compareTo(((Map.Entry)o1).getValue());
            }
        });
        List lsKey = lsEntry.stream().map(Map.Entry::getKey).collect(Collectors.toList());
        return lsKey;
    }

    public static <K, V> List<V> getLsValueByLsKey(Map<K, V> map, Collection<K> collKey) {
        ArrayList lsData = new ArrayList();
        collKey.forEach(key -> {
            Object value = map.get(key);
            if (value == null) {
                return;
            }
            lsData.add(value);
        });
        return lsData;
    }

    public static <K, V> Map<K, V> filterByLsKey(Map<K, V> map, Collection<K> collKey) {
        HashMap mapOut = new HashMap();
        collKey.forEach(key -> {
            Object value = map.get(key);
            if (value == null) {
                return;
            }
            mapOut.put(key, value);
        });
        return mapOut;
    }

    private static <K, V> Set<K> mergeKey(List<Map<K, V>> lsMap) {
        HashSet setKey = new HashSet();
        lsMap.forEach(map -> setKey.addAll(map.keySet()));
        return setKey;
    }

    public static <K, V, T> Map<K, T> map(Map<K, V> map, Function<V, T> func) {
        HashMap mapData = new HashMap();
        map.entrySet().forEach(entry -> {
            Object key = entry.getKey();
            Object value = entry.getValue();
            Object data = func.apply(value);
            mapData.put(key, data);
        });
        return mapData;
    }

    public static <K, V> Map<K, V> reduce(List<Map<K, V>> lsMap, V def, BiFunction<V, V, V> func) {
        HashMap<K, V> mapData = new HashMap<K, V>();
        Set<K> setKey = XMap.mergeKey(lsMap);
        for (K key : setKey) {
            for (Map<K, V> map : lsMap) {
                V data = mapData.getOrDefault(key, def);
                V value = map.getOrDefault(key, def);
                data = func.apply(data, value);
                mapData.put(key, data);
            }
        }
        return mapData;
    }

    public static <K, V extends Number> Map<K, Double> normLog(Map<K, V> map) {
        Number max = null;
        for (Number val : map.values()) {
            if (max != null && !(val.doubleValue() > max.doubleValue())) continue;
            max = val;
        }
        double maxLog = 1.0;
        if (max.doubleValue() > 1.0) {
            maxLog = Math.log(max.doubleValue());
        }
        HashMap<K, Double> mapIdSongCountNorm = new HashMap<K, Double>();
        for (Map.Entry<K, V> keyVal : map.entrySet()) {
            K key = keyVal.getKey();
            Number val = (Number)keyVal.getValue();
            mapIdSongCountNorm.put(key, Math.log(val.doubleValue()) / maxLog);
        }
        return mapIdSongCountNorm;
    }

    public static <K, V extends Number> Map<K, Double> normMax(Map<K, V> map) {
        Number max = null;
        for (Number val : map.values()) {
            if (max != null && !(val.doubleValue() > max.doubleValue())) continue;
            max = val;
        }
        HashMap<K, Double> mapIdSongCountNorm = new HashMap<K, Double>();
        for (Map.Entry<K, V> keyVal : map.entrySet()) {
            K key = keyVal.getKey();
            Number val = (Number)keyVal.getValue();
            double countNorm = val.doubleValue() / max.doubleValue();
            mapIdSongCountNorm.put(key, countNorm);
        }
        return mapIdSongCountNorm;
    }
}

