/*
 * Decompiled with CFR 0.152.
 */
package org.xyou.xcommon.pool;

import java.util.ArrayList;
import java.util.List;
import org.xyou.xcommon.base.XBaseObject;
import org.xyou.xcommon.pool.XPoolItem;
import org.xyou.xcommon.queue.XQueue;

public final class XPool<V>
extends XBaseObject {
    private static final long serialVersionUID = 1L;
    private final Integer sizeMax;
    private final transient XQueue<XPoolItem<V>> queue;

    public XPool(int sizeMax) {
        this.sizeMax = sizeMax;
        this.queue = new XQueue(sizeMax);
    }

    public boolean isFull() {
        return this.queue.isFull();
    }

    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    public int size() {
        return this.queue.size();
    }

    public List<XPoolItem<V>> take(int numItem) {
        return this.queue.take(numItem);
    }

    public XPoolItem<V> take() {
        return this.queue.take();
    }

    boolean offer(XPoolItem<V> item) {
        return this.queue.offer(item);
    }

    public boolean offer(V data) {
        return this.offer((V)new XPoolItem<V>(data, this));
    }

    public List<V> unload(int numItem) {
        ArrayList<V> lsData = new ArrayList<V>(numItem);
        for (int idxObject = 0; idxObject < numItem; ++idxObject) {
            XPoolItem<V> item = this.queue.take();
            V data = item.getData();
            lsData.add(data);
        }
        return lsData;
    }

    public Integer getSizeMax() {
        return this.sizeMax;
    }

    XQueue<XPoolItem<V>> getQueue() {
        return this.queue;
    }
}

